/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.cas2iob.main;

import de.julielab.jcore.consumer.cas2iob.utils.UIMAUtils;
import de.julielab.jcore.types.Paragraph;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.types.pubmed.Header;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.segmentationEvaluator.IOBToken;
import de.julielab.segmentationEvaluator.IOToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToIOBConsumer
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToIOBConsumer.class);
    private final String SENTENCE_END_MARK = "SENTENCE_END_MARKER";
    private final String PARAGRAPH_END_MARK = "PARAGRAPH_END_MARKER";
    String mode = null;
    String outFolder = null;
    String typePath = null;
    String[] labels = null;
    HashMap<String, String> objNameMethMap = null;
    HashMap<String, String> labelIOBMap = null;
    int id = 1;

    public void initialize() throws ResourceInitializationException {
        String[] parts;
        int i;
        LOGGER.info("Initializing...");
        String regexp = "[\\s=/\\|]";
        this.labels = (String[])this.getConfigParameterValue("labels");
        this.outFolder = (String)this.getConfigParameterValue("outFolder");
        String[] labelNameMethods = (String[])this.getConfigParameterValue("labelNameMethods");
        String[] iobLabelNames = (String[])this.getConfigParameterValue("iobLabelNames");
        this.typePath = (String)this.getConfigParameterValue("typePath");
        if (this.typePath == null) {
            this.typePath = "";
        }
        this.mode = (String)this.getConfigParameterValue("mode");
        if (this.mode.equals("IOB") || this.mode.equals("iob")) {
            this.mode = "IOB";
        } else if (this.mode.equals("IO") || this.mode.equals("io")) {
            this.mode = "IO";
        } else {
            throw new ResourceInitializationException();
        }
        if (labelNameMethods != null) {
            this.objNameMethMap = new HashMap();
            for (i = 0; i < labelNameMethods.length; ++i) {
                parts = labelNameMethods[i].split("[\\s=/\\|]");
                if (parts.length == 1) {
                    this.objNameMethMap.put(this.typePath + parts[0], null);
                    continue;
                }
                this.objNameMethMap.put(this.typePath + parts[0], parts[1]);
            }
        }
        if (iobLabelNames != null) {
            this.labelIOBMap = new HashMap();
            for (i = 0; i < iobLabelNames.length; ++i) {
                parts = iobLabelNames[i].split("[\\s=/\\|]");
                this.labelIOBMap.put(parts[0], parts[1]);
            }
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        LOGGER.info("Converting CAS to IO(B)Tokens...");
        IOToken[] ioTokens = this.convertToIOB(cas);
        LOGGER.info("Writing IO(B) file...");
        String outPathName = Paths.get(this.outFolder, this.getDocumentId(cas)).toString() + ".iob";
        if (Files.notExists(Paths.get(this.outFolder, new String[0]), new LinkOption[0])) {
            new File(this.outFolder).mkdirs();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outPathName));
            for (IOToken token : ioTokens) {
                if (token.getText().equals("") || token.getText().equals("SENTENCE_END_MARKER")) {
                    bw.write("\n");
                    continue;
                }
                if (token.getText().equals("") || token.getText().equals("PARAGRAPH_END_MARKER")) {
                    bw.write("\n\n");
                    continue;
                }
                bw.write(token + "\n");
            }
            if (bw != null) {
                bw.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("The IO(B) file was written to " + outPathName);
    }

    public IOToken[] convertToIOB(CAS cas) {
        Boolean no_paragraphs = true;
        ArrayList<IOToken> ioTokens = new ArrayList<IOToken>();
        JCas jcas = null;
        try {
            jcas = cas.getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        Iterator[] annotationIters = new Iterator[this.objNameMethMap.size()];
        Iterator<String> it = this.objNameMethMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String objName = it.next();
            Annotation ann = null;
            try {
                ann = JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)objName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            annotationIters[i] = indexes.getAnnotationIndex(ann.getTypeIndexID()).iterator();
            ++i;
        }
        TreeMap<Integer, IOToken> ioTokenMap = new TreeMap<Integer, IOToken>();
        this.tokenLabeling(ioTokenMap, annotationIters, jcas);
        System.out.println("map: " + ioTokenMap);
        FSIterator paragraphIter = indexes.getAnnotationIndex(Paragraph.type).iterator();
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        while (paragraphIter.hasNext()) {
            paragraphs.add((Paragraph)paragraphIter.next());
        }
        if (paragraphs.isEmpty()) {
            Paragraph dParagraph = null;
            try {
                dParagraph = (Paragraph)JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)Paragraph.class.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            dParagraph.setBegin(0);
            dParagraph.setEnd(jcas.getDocumentText().length());
            dParagraph.addToIndexes(jcas);
            paragraphs.add(dParagraph);
        }
        Paragraph lastPara = null;
        int overallSentCount = 0;
        for (Sentence sentence : indexes.getAnnotationIndex(Sentence.type)) {
            int sentCount = 0;
            Paragraph currentParagraph = lastPara;
            for (Paragraph para : paragraphs) {
                if (para.getBegin() <= sentence.getBegin() && para.getEnd() >= sentence.getEnd()) {
                    currentParagraph = para;
                }
                ArrayList tokenList = (ArrayList)UIMAUtils.getAnnotations(jcas, (Annotation)sentence, new Token(jcas, 0, 0).getClass());
                for (int i2 = 0; i2 < tokenList.size(); ++i2) {
                    IOBToken ioToken;
                    Token token = (Token)tokenList.get(i2);
                    if (i2 == 0 && overallSentCount > 0) {
                        ioToken = null;
                        ioToken = currentParagraph != lastPara ? new IOBToken("PARAGRAPH_END_MARKER", "PARAGRAPH_END_MARKER") : new IOBToken("SENTENCE_END_MARKER", "SENTENCE_END_MARKER");
                        ioTokenMap.put(token.getBegin() - 1, (IOToken)ioToken);
                    }
                    if (ioTokenMap.containsKey(token.getBegin())) continue;
                    ioToken = new IOBToken(token.getCoveredText(), "O");
                    ioTokenMap.put(token.getBegin(), (IOToken)ioToken);
                }
                ++overallSentCount;
                ++sentCount;
            }
        }
        Set<Integer> beginSet = ioTokenMap.keySet();
        for (Integer begin : beginSet) {
            IOToken ioToken = ioTokenMap.get(begin);
            ioTokens.add(ioToken);
        }
        IOToken[] ret = new IOToken[ioTokens.size()];
        if (this.mode.equals("IOB")) {
            ret = ioTokens.toArray(ret);
        } else {
            for (int i3 = 0; i3 < ioTokens.size(); ++i3) {
                IOBToken iobToken = (IOBToken)ioTokens.get(i3);
                ret[i3] = iobToken.toXIoToken();
            }
        }
        return ret;
    }

    private void tokenLabeling(TreeMap<Integer, IOToken> ioTokenMap, Iterator[] annotationIters, JCas jcas) {
        AnnotationIndex tokenIndex = jcas.getJFSIndexRepository().getAnnotationIndex(Token.type);
        for (int i = 0; i < annotationIters.length; ++i) {
            Iterator annoIter = annotationIters[i];
            while (annoIter.hasNext()) {
                Annotation ann = (Annotation)annoIter.next();
                String label = this.getAnnotationLabel(ann);
                FSIterator subtokenIterator = tokenIndex.subiterator((AnnotationFS)ann);
                try {
                    Token token = (Token)subtokenIterator.next();
                    Integer begin = token.getBegin();
                    if (!ioTokenMap.containsKey(begin)) {
                        IOBToken ioToken = new IOBToken(token.getCoveredText(), "B_" + label);
                        ioTokenMap.put(begin, (IOToken)ioToken);
                        while (subtokenIterator.hasNext()) {
                            token = (Token)subtokenIterator.next();
                            begin = token.getBegin();
                            ioToken = new IOBToken(token.getCoveredText(), "I_" + label);
                            ioTokenMap.put(begin, (IOToken)ioToken);
                        }
                        continue;
                    }
                    this.handleCompetingAnnotations(ioTokenMap, label, subtokenIterator, token, begin);
                }
                catch (NoSuchElementException e) {
                    LOGGER.warn("no token in anno: " + ann.getCoveredText());
                }
            }
        }
    }

    private void handleCompetingAnnotations(TreeMap<Integer, IOToken> ioTokenMap, String label, FSIterator subtokenIterator, Token token, Integer begin) {
        int oldLength = 0;
        Set<Integer> keySet = ioTokenMap.keySet();
        for (Integer index : keySet) {
            IOToken actToken = ioTokenMap.get(index);
            if (index < begin) continue;
            if (!actToken.getLabel().equals(label) || !actToken.getIobMark().equals("I") && oldLength > 0) break;
            ++oldLength;
        }
        HashMap<IOBToken, Integer> newTokenSeq = new HashMap<IOBToken, Integer>();
        IOBToken ioToken2 = new IOBToken(token.getCoveredText(), "B_" + label);
        newTokenSeq.put(ioToken2, begin);
        while (subtokenIterator.hasNext()) {
            token = (Token)subtokenIterator.next();
            begin = token.getBegin();
            ioToken2 = new IOBToken(token.getCoveredText(), "I_" + label);
            newTokenSeq.put(ioToken2, begin);
        }
        if (newTokenSeq.size() > oldLength) {
            Set hashKeys = newTokenSeq.keySet();
            for (IOBToken ioToken2 : hashKeys) {
                begin = (Integer)newTokenSeq.get(ioToken2);
                ioTokenMap.put(begin, (IOToken)ioToken2);
            }
        }
    }

    private String getAnnotationLabel(Annotation ann) {
        String ret = null;
        Class<?> annClass = ann.getClass();
        Method getLabelMethod = null;
        String methodName = this.objNameMethMap.get(annClass.getName());
        try {
            if (methodName == null) {
                ret = annClass.getName();
            } else {
                getLabelMethod = annClass.getMethod(methodName, new Class[0]);
                ret = (String)getLabelMethod.invoke((Object)ann, (Object[])null);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("The class \"" + annClass.getName() + "\" does not have a method \"" + methodName + "\".");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ret != null) {
            for (String label : this.labels) {
                if (!ret.equals(label)) continue;
                ret = null;
            }
        }
        if (ret != null && this.labelIOBMap.get(ret) != null) {
            ret = this.labelIOBMap.get(ret);
        }
        return ret;
    }

    private String getDocumentId(CAS cas) {
        Header header = null;
        Type headerType = cas.getTypeSystem().getType(Header.class.getCanonicalName());
        try {
            FSIterator iterator = cas.getJCas().getAnnotationIndex(Header.type).iterator();
            if (iterator.hasNext()) {
                header = (Header)iterator.next();
            }
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        if (header != null) {
            return header.getDocId();
        }
        return new Integer(this.id++).toString();
    }
}

