/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.iexml;

import de.julielab.jcore.types.mantra.Corpus;
import de.julielab.jcore.types.mantra.Entity;
import generated.AnnoType;
import generated.Document;
import generated.E;
import generated.Group;
import generated.Lang;
import generated.NER;
import generated.Unit;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEXMLConsumer
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(IEXMLConsumer.class);
    public static final String PARAM_OUTPUTFILE = "outputFile";
    private static final String PARAM_AUTHOR = "author";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String WRITE_NER = "writeNER";
    private String outputFile;
    private String author;
    private String description;
    private boolean writeNER;
    private static generated.Corpus xmlCorpus = null;

    public void initialize() throws ResourceInitializationException {
        this.outputFile = (String)this.getConfigParameterValue(PARAM_OUTPUTFILE);
        this.author = (String)this.getConfigParameterValue(PARAM_AUTHOR);
        this.description = (String)this.getConfigParameterValue(PARAM_DESCRIPTION);
        Object x = this.getConfigParameterValue(WRITE_NER);
        this.writeNER = x != null && (Boolean)x != false;
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        JCas jcas = null;
        try {
            jcas = cas.getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        String docText = jcas.getDocumentText();
        if (xmlCorpus == null) {
            this.setXMLCorpusAttributes(jcas);
        }
        de.julielab.jcore.types.mantra.Document doc = (de.julielab.jcore.types.mantra.Document)jcas.getAnnotationIndex(de.julielab.jcore.types.mantra.Document.type).iterator().next();
        Document xmlDoc = new Document();
        xmlDoc.setId(doc.getId());
        for (de.julielab.jcore.types.mantra.Unit unit : jcas.getAnnotationIndex(de.julielab.jcore.types.mantra.Unit.type)) {
            Unit xmlUnit = new Unit();
            int offset = unit.getBegin();
            xmlUnit.setId(unit.getId());
            Unit.Text xmlText = new Unit.Text();
            xmlText.getContent().add(docText.substring(unit.getBegin(), unit.getEnd()));
            xmlUnit.setText(xmlText);
            FSIterator entities = jcas.getAnnotationIndex(Entity.type).subiterator((AnnotationFS)unit);
            int numberOfEntities = 1;
            String idTemplate = unit.getId() + ".e%s";
            while (entities.hasNext()) {
                Entity e = (Entity)entities.next();
                E xmlE = new E();
                xmlE.setOffset(BigInteger.valueOf(e.getBegin() - offset));
                xmlE.setLen(BigInteger.valueOf(e.getEnd() - e.getBegin()));
                xmlE.setId(String.format(idTemplate, numberOfEntities));
                if (!this.writeNER) {
                    xmlE.setSrc(e.getSource());
                    xmlE.setCui(e.getCui());
                    xmlE.setType(e.getSemanticType());
                    xmlE.setGrp(Group.fromValue((String)e.getSemanticGroup()));
                }
                List content = xmlE.getContent();
                content.add(e.getCoveredText());
                if (this.writeNER) {
                    FSArray ners = e.getNer();
                    for (int i = 0; i < ners.size(); ++i) {
                        NER xmlNER = new NER();
                        de.julielab.jcore.types.mantra.NER ner = (de.julielab.jcore.types.mantra.NER)ners.get(i);
                        xmlNER.setGroup(Group.fromValue((String)ner.getSemanticGroup()));
                        xmlNER.setProbability(ner.getProbability());
                        content.add((Serializable)xmlNER);
                    }
                }
                ++numberOfEntities;
                xmlUnit.getE().add(xmlE);
            }
            xmlDoc.getUnit().add(xmlUnit);
        }
        xmlCorpus.getDocument().add(xmlDoc);
    }

    private void setXMLCorpusAttributes(JCas jcas) {
        Corpus corpus = (Corpus)jcas.getAnnotationIndex(Corpus.type).iterator().next();
        xmlCorpus = new generated.Corpus();
        xmlCorpus.setAnnotationType(AnnoType.STANDOFF);
        xmlCorpus.setAuthor(this.author);
        xmlCorpus.setDescription(this.description);
        xmlCorpus.setDocType(corpus.getDocType());
        xmlCorpus.setLang(Lang.fromValue((String)corpus.getLanguage()));
        String id = this.outputFile.substring(this.outputFile.lastIndexOf(File.separator) + 1, this.outputFile.lastIndexOf("."));
        xmlCorpus.setId(id);
        try {
            GregorianCalendar c = new GregorianCalendar();
            de.julielab.jcore.types.Date creationDate = corpus.getCreationDate();
            c.set(creationDate.getYear(), creationDate.getMonth() - 1, creationDate.getDay());
            XMLGregorianCalendar xmlCreationDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
            xmlCreationDate.setTimezone(Integer.MIN_VALUE);
            xmlCorpus.setCreationDate(xmlCreationDate);
            GregorianCalendar d = new GregorianCalendar();
            d.setGregorianChange(new Date());
            XMLGregorianCalendar xmlAnnotationDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(d);
            xmlAnnotationDate.setTimezone(Integer.MIN_VALUE);
            xmlCorpus.setAnnotationDate(xmlAnnotationDate);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        LOGGER.info("Writing altered content back to " + this.outputFile + ".");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"generated");
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)xmlCorpus, new File(this.outputFile));
        }
        catch (JAXBException e) {
            LOGGER.error("Something got wrong while trying to write content to " + this.outputFile + ".");
        }
        super.destroy();
    }
}

