/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.gnp;

import com.pengyifan.bioc.BioCCollection;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioCCollectionWriter {
    private static final Logger log = LoggerFactory.getLogger(BioCCollectionWriter.class);
    private int numFilesPerDir;
    private Path baseDir;
    private Path currentDir;
    private int numWrittenIntoCurrentDir;
    private int currentDirNum;

    public BioCCollectionWriter(int numFilesPerDir, Path baseDir) {
        this.numFilesPerDir = numFilesPerDir;
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBioCCollection(BioCCollection collection) throws XMLStreamException, IOException {
        Class<BioCCollectionWriter> clazz = BioCCollectionWriter.class;
        synchronized (BioCCollectionWriter.class) {
            Path collectionFile;
            int i;
            if (this.currentDir == null) {
                i = 0;
                do {
                    this.currentDirNum = i++;
                    this.currentDir = Path.of(this.baseDir.toString(), "bioc_collections_" + this.currentDirNum);
                } while (Files.exists(this.currentDir, new LinkOption[0]));
            }
            i = 0;
            while (Files.exists(collectionFile = Path.of(this.currentDir.toString(), "bioc_collection_" + this.currentDirNum + "_" + i++ + ".xml"), new LinkOption[0])) {
            }
            if (!Files.exists(collectionFile.getParent(), new LinkOption[0])) {
                log.debug("Creating base BioC collection directory {}", (Object)this.baseDir);
                Files.createDirectories(collectionFile.getParent(), new FileAttribute[0]);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (collectionFile == null) {
                throw new IllegalStateException("No file for the next collection was constructed. This is a programming error.");
            }
            com.pengyifan.bioc.io.BioCCollectionWriter writer = new com.pengyifan.bioc.io.BioCCollectionWriter(collectionFile);
            writer.writeCollection(collection);
            ++this.numWrittenIntoCurrentDir;
            if (this.numWrittenIntoCurrentDir >= this.numFilesPerDir) {
                this.currentDir = null;
                this.numWrittenIntoCurrentDir = 0;
            }
            return;
        }
    }
}

