/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.gnp;

import com.pengyifan.bioc.BioCCollection;
import com.pengyifan.bioc.BioCDocument;
import de.julielab.jcore.consumer.gnp.BioCCollectionWriter;
import de.julielab.jcore.consumer.gnp.BioCDocumentPopulator;
import de.julielab.jcore.types.Gene;
import de.julielab.jcore.utility.JCoReTools;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe GNormPlus BioC Writer", description="Writes CAS documents into the BioC XML format used by the gene tagger and normalizer GNormPlus.", vendor="JULIE Lab Jena, Germany")
@TypeCapability(inputs={}, outputs={})
public class GNormPlusFormatWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_NUM_DOCS_PER_FILE = "NumDocsPerFile";
    public static final String PARAM_NUM_FILES_PER_DIR = "NumFilesPerDir";
    public static final String PARAM_BASE_DIR = "BaseDirectory";
    public static final String PARAM_ADD_GENES = "AddGenes";
    public static final String PARAM_GENE_TYPE_NAME = "GeneTypeName";
    private static final Logger log = LoggerFactory.getLogger(GNormPlusFormatWriter.class);
    @ConfigurationParameter(name="NumDocsPerFile", description="The number of documents (i.e. CASes) that should be written into a single BioC XML file.")
    private int numDocsPerFile;
    @ConfigurationParameter(name="NumFilesPerDir", description="The number of files that should be put in a directory before a new one is created.")
    private int numDocsPerDir;
    @ConfigurationParameter(name="BaseDirectory", description="The base directory into which to create new directories that contain the actual BioC collection files.")
    private String baseDirectory;
    @ConfigurationParameter(name="AddGenes", mandatory=false, defaultValue={"false"}, description="If set to true, all Gene annotations in the CAS will be added to the BioC documents. The default type used is de.julielab.jcore.types.Gene. This can be changed with the GeneTypeName parameter.")
    private boolean addGenes;
    @ConfigurationParameter(name="GeneTypeName", mandatory=false, defaultValue={"de.julielab.jcore.types.Gene"}, description="The UIMA type denoting gene annotations that should be written into the BioC format when the AddGenes parameter is set to true.")
    private String geneTypeName;
    private BioCDocumentPopulator bioCDocumentPopulator;
    private BioCCollectionWriter bioCCollectionWriter;
    private BioCCollection currentCollection;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.numDocsPerFile = (Integer)aContext.getConfigParameterValue(PARAM_NUM_DOCS_PER_FILE);
        this.numDocsPerDir = (Integer)aContext.getConfigParameterValue(PARAM_NUM_FILES_PER_DIR);
        this.baseDirectory = (String)aContext.getConfigParameterValue(PARAM_BASE_DIR);
        this.addGenes = (Boolean)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_ADD_GENES)).orElse(false);
        this.geneTypeName = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_GENE_TYPE_NAME)).orElse(Gene.class.getCanonicalName());
        try {
            this.bioCDocumentPopulator = new BioCDocumentPopulator(this.addGenes, this.geneTypeName);
            this.bioCCollectionWriter = new BioCCollectionWriter(this.numDocsPerDir, Path.of(this.baseDirectory, new String[0]));
            this.currentCollection = new BioCCollection("UTF-8", "1.0", new Date().toString(), true, "JCoRe GNormPlus BioC Writer", "PubTator.key");
        }
        catch (ClassNotFoundException e) {
            log.error("Gene annotation class {} could not be found.", (Object)this.geneTypeName, (Object)e);
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            BioCDocument doc = this.bioCDocumentPopulator.populate(jCas);
            if (doc.getPassageCount() > 0) {
                this.currentCollection.addDocument(doc);
            }
            if (this.currentCollection.getDocmentCount() >= this.numDocsPerFile) {
                this.bioCCollectionWriter.writeBioCCollection(this.currentCollection);
                this.currentCollection.clearDocuments();
                this.currentCollection.clearInfons();
            }
        }
        catch (Exception e) {
            log.error("Exception was raised for document {}", (Object)JCoReTools.getDocId((JCas)jCas));
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            System.out.println("CollectionProcessComplete: Writing BioC collection of size " + this.currentCollection.getDocmentCount());
            this.bioCCollectionWriter.writeBioCCollection(this.currentCollection);
        }
        catch (Throwable e) {
            log.error("Could not write final batch of BioCDocuments.", e);
            throw new AnalysisEngineProcessException(e);
        }
    }
}

