/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.gnp;

import com.pengyifan.bioc.BioCAnnotation;
import com.pengyifan.bioc.BioCDocument;
import com.pengyifan.bioc.BioCLocation;
import com.pengyifan.bioc.BioCPassage;
import de.julielab.jcore.types.AbstractText;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.Caption;
import de.julielab.jcore.types.ConceptMention;
import de.julielab.jcore.types.Paragraph;
import de.julielab.jcore.types.Title;
import de.julielab.jcore.types.Zone;
import de.julielab.jcore.utility.JCoReTools;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioCDocumentPopulator {
    private static final Logger log = LoggerFactory.getLogger(BioCDocumentPopulator.class);
    private boolean addGenes;
    private Class<? extends ConceptMention> geneTypeClass;

    public BioCDocumentPopulator(boolean addGenes, String geneTypeName) throws ClassNotFoundException {
        this.addGenes = addGenes;
        this.geneTypeClass = Class.forName(geneTypeName);
    }

    public BioCDocument populate(JCas jCas) {
        BioCDocument doc = new BioCDocument(JCoReTools.getDocId((JCas)jCas));
        AnnotationIndex zoneIndex = jCas.getAnnotationIndex(Zone.type);
        int annotationId = 0;
        for (Zone z : zoneIndex) {
            if (z.getCoveredText().isBlank()) continue;
            BioCPassage p = null;
            if (z instanceof Title) {
                String titleType;
                Title t = (Title)z;
                String titleTypeString = t.getTitleType();
                if (titleTypeString == null) {
                    titleTypeString = "other";
                }
                switch (titleTypeString) {
                    case "document": {
                        titleType = "title";
                        break;
                    }
                    case "section": {
                        titleType = "section_title";
                        break;
                    }
                    case "figure": {
                        titleType = "figure_title";
                        break;
                    }
                    case "table": {
                        titleType = "table_title";
                        break;
                    }
                    case "abstractSection": {
                        titleType = "null";
                        break;
                    }
                    case "other": {
                        titleType = "other_title";
                    }
                    default: {
                        log.debug("Unhandled title type {}", (Object)titleTypeString);
                        titleType = "other_title";
                    }
                }
                if (titleType != null) {
                    p = this.getPassageForAnnotation((Annotation)t);
                    p.putInfon("type", titleType);
                    doc.addPassage(p);
                }
            } else if (z instanceof AbstractText) {
                AbstractText at = (AbstractText)z;
                p = this.getPassageForAnnotation((Annotation)at);
                p.putInfon("type", "abstract");
                doc.addPassage(p);
            } else if (z instanceof Paragraph) {
                Paragraph pa = (Paragraph)z;
                p = this.getPassageForAnnotation((Annotation)pa);
                p.putInfon("type", "paragraph");
                doc.addPassage(p);
            } else if (z instanceof Caption) {
                Caption c = (Caption)z;
                p = this.getPassageForAnnotation((Annotation)c);
                if (c.getCaptionType() == null) {
                    throw new IllegalArgumentException("The captionType feature is null for " + c);
                }
                p.putInfon("type", c.getCaptionType());
                doc.addPassage(p);
            }
            if (!this.addGenes) continue;
            annotationId = this.addGenesToPassage(jCas, z, p, annotationId);
        }
        return doc;
    }

    private int addGenesToPassage(JCas jCas, Zone z, BioCPassage p, int annotationId) {
        if (p != null) {
            Iterable geneIt = JCasUtil.subiterate((JCas)jCas, this.geneTypeClass, (AnnotationFS)z, (boolean)false, (boolean)true);
            for (ConceptMention g : geneIt) {
                String specificType;
                BioCAnnotation annotation = new BioCAnnotation(String.valueOf(annotationId++));
                annotation.setText(g.getCoveredText());
                String type = "Gene";
                String string = specificType = g.getSpecificType() != null ? g.getSpecificType().toLowerCase() : null;
                if (specificType != null && (specificType.contains("familiy") || specificType.contains("family") || specificType.contains("complex"))) {
                    type = "FamilyName";
                } else if (specificType != null && specificType.contains("domain")) {
                    type = "DomainMotif";
                }
                annotation.putInfon("type", type);
                annotation.addLocation(new BioCLocation(g.getBegin(), g.getEnd() - g.getBegin()));
                p.addAnnotation(annotation);
            }
        }
        return annotationId;
    }

    private BioCPassage getPassageForAnnotation(Annotation a) {
        BioCPassage p = new BioCPassage();
        p.setOffset(a.getBegin());
        p.setText(a.getCoveredText().replaceAll("\n", " "));
        p.putInfon("uimatype", a.getClass().getCanonicalName());
        return p;
    }
}

