/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.multiplier.gnp;

import de.julielab.jcore.consumer.gnp.BioCDocumentPopulator;
import de.julielab.jcore.multiplier.gnp.GNormPlusMultiplierLogic;
import de.julielab.jcore.reader.xml.XMLDBMultiplier;
import de.julielab.jcore.types.Gene;
import java.io.IOException;
import java.util.Optional;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe GNormPlus XML Database Multiplier", description="A CAS multiplier to be used with the DB XML multiplier reader in place of the DB XML multiplier. It wraps the JULIE Lab variant of the GNormPlus gene ID mapper. It is a multiplier because this enables batch-processing of documents with GNormPlus which makes the processing more efficient.", vendor="JULIE Lab Jena, Germany")
@TypeCapability(inputs={}, outputs={"de.julielab.jcore.types.ConceptMention", "de.julielab.jcore.types.Organism"})
public class GNormPlusXMLDBMultiplier
extends XMLDBMultiplier {
    public static final String PARAM_SKIP_UNCHANGED_DOCUMENTS = "SkipUnchangedDocuments";
    private static final Logger log = LoggerFactory.getLogger(GNormPlusXMLDBMultiplier.class);
    private static boolean shutdownHookInstalled = false;
    @ConfigurationParameter(name="UseExistingGeneAnnotations", mandatory=false, defaultValue={"false"}, description="If set to true, all Gene annotations in the CAS will be added to the BioC documents. The default type used is de.julielab.jcore.types.Gene. This can be changed with the InputGeneTypeName parameter.")
    private boolean addExistingGenes;
    @ConfigurationParameter(name="OutputGeneTypeName", mandatory=false, defaultValue={"de.julielab.jcore.types.Gene"}, description="The UIMA type denoting gene annotations that should be created by this component. Must by a sub type of de.julielab.jcore.types.ConceptMention. Defaults to de.julielab.jcore.types.Gene.")
    private String outputGeneTypeName;
    @ConfigurationParameter(name="GNormPlusSetupFile", mandatory=false, description="File path or class path resource path to the setup.txt file for GNormPlus. If not specified, a default setup file is loaded that expects the Dictionary/ directory directly under the working directory, performs gene recognition with the CRF and thus expects the GNormPlus CRF directory directly under the working directory and maps the found genes to NCBI gene IDs for all organisms.")
    private String setupFile;
    @ConfigurationParameter(name="InputGeneTypeName", mandatory=false, defaultValue={"de.julielab.jcore.types.Gene"}, description="The UIMA type denoting gene annotations that should be taken from the CAS and written into the BioC format for GNormPlus to use instead of running its own gene recognition when the UseExistingGeneAnnotations parameter is set to true.")
    private String geneTypeName;
    @ConfigurationParameter(name="OutputDirectory", mandatory=false, description="Optional. If specified, the GNormPlus output files in BioC format will be saved to the given directory. In this way, this component can be used directly as a BioC XML writer through the GNormPlus algorithm.")
    private String outputDirectory;
    @ConfigurationParameter(name="FocusSpecies", mandatory=false, description="If given, all gene mentions are assigned to this NCBI taxonomy ID, i.e. species recognition is omitted.")
    private String focusSpecies;
    @ConfigurationParameter(name="SkipUnchangedDocuments", mandatory=false, description="Whether to omit GNormPlus processing on documents that already exist in the XMI database table and whose document text has not changed.")
    private boolean skipUnchangedDocuments;
    private BioCDocumentPopulator bioCDocumentPopulator;
    private GNormPlusMultiplierLogic multiplierLogic;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.addExistingGenes = (Boolean)Optional.ofNullable(aContext.getConfigParameterValue("UseExistingGeneAnnotations")).orElse(false);
        this.geneTypeName = (String)Optional.ofNullable(aContext.getConfigParameterValue("InputGeneTypeName")).orElse(Gene.class.getCanonicalName());
        this.skipUnchangedDocuments = (Boolean)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_SKIP_UNCHANGED_DOCUMENTS)).orElse(false);
        try {
            this.bioCDocumentPopulator = new BioCDocumentPopulator(this.addExistingGenes, this.geneTypeName);
        }
        catch (ClassNotFoundException e) {
            log.error("Gene annotation class {} could not be found.", (Object)this.geneTypeName, (Object)e);
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            this.multiplierLogic = new GNormPlusMultiplierLogic(aContext, this.bioCDocumentPopulator, () -> super.hasNext(), () -> {
                try {
                    return (JCas)super.next();
                }
                catch (AnalysisEngineProcessException e) {
                    log.error("Error when calling next() of the base multiplier.");
                    throw new RuntimeException(e);
                }
            }, () -> this.getEmptyJCas(), this.skipUnchangedDocuments);
        }
        catch (IOException e) {
            log.error("Could not initialize GNormPlus", (Throwable)e);
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public boolean hasNext() {
        try {
            return this.multiplierLogic.hasNext();
        }
        catch (Throwable t) {
            log.error("Error when checking hasNext() on multiplier", t);
            return false;
        }
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        try {
            return this.multiplierLogic.next();
        }
        catch (Throwable t) {
            log.error("Error when retrieving next multiplier CAS", t);
            throw new AnalysisEngineProcessException(t);
        }
    }
}

