/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.multiplier.gnp;

import com.pengyifan.bioc.BioCCollection;
import com.pengyifan.bioc.BioCDocument;
import de.julielab.jcore.ae.gnp.GNormPlusProcessing;
import de.julielab.jcore.consumer.gnp.BioCDocumentPopulator;
import de.julielab.jcore.reader.BioCCasPopulator;
import de.julielab.jcore.types.Gene;
import de.julielab.jcore.types.ext.DBProcessingMetaData;
import de.julielab.jcore.utility.JCoReTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class GNormPlusMultiplierLogic {
    private static final Logger log = LoggerFactory.getLogger(GNormPlusMultiplierLogic.class);
    private BioCDocumentPopulator bioCDocumentPopulator;
    private BioCCasPopulator bioCCasPopulator;
    private String outputDirectory;
    private Supplier<Boolean> baseMultiplierHasNext;
    private Supplier<JCas> baseMultiplierNext;
    private Supplier<JCas> multiplierGetEmptyCas;
    private int currentCollectionIndex;
    private int currentBiocResultCollectionIndex;
    private List<byte[]> cachedCasData;
    private boolean skipUnchangedDocuments;
    private String outputGeneTypeName;

    public GNormPlusMultiplierLogic(UimaContext aContext, BioCDocumentPopulator bioCDocumentPopulator, Supplier<Boolean> baseMultiplierHasNext, Supplier<JCas> baseMultiplierNext, Supplier<JCas> multiplierGetEmptyCas, boolean skipUnchangedDocuments) throws IOException {
        this.skipUnchangedDocuments = skipUnchangedDocuments;
        String setupFile = (String)Optional.ofNullable(aContext.getConfigParameterValue("GNormPlusSetupFile")).orElse("/de/julielab/jcore/ae/gnp/config/setup_do_ner.txt");
        String focusSpecies = (String)Optional.ofNullable(aContext.getConfigParameterValue("FocusSpecies")).orElse("");
        this.outputGeneTypeName = (String)Optional.ofNullable(aContext.getConfigParameterValue("OutputGeneTypeName")).orElse(Gene.class.getCanonicalName());
        this.outputDirectory = (String)Optional.ofNullable(aContext.getConfigParameterValue("OutputDirectory")).orElse("");
        this.bioCDocumentPopulator = bioCDocumentPopulator;
        this.baseMultiplierHasNext = baseMultiplierHasNext;
        this.baseMultiplierNext = baseMultiplierNext;
        this.multiplierGetEmptyCas = multiplierGetEmptyCas;
        this.cachedCasData = new ArrayList<byte[]>();
        this.currentCollectionIndex = 0;
        this.currentBiocResultCollectionIndex = 0;
        GNormPlusProcessing.initializeGNormPlus(setupFile, focusSpecies);
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        try {
            JCas jCas;
            if (this.currentCollectionIndex == this.cachedCasData.size()) {
                this.currentCollectionIndex = 0;
                this.currentBiocResultCollectionIndex = 0;
                BioCCollection gnormPlusInputCollection = GNormPlusProcessing.createEmptyJulieLabBioCCollection();
                this.cachedCasData.clear();
                while (this.baseMultiplierHasNext.get().booleanValue()) {
                    jCas = this.baseMultiplierNext.get();
                    boolean isDocumentHashUnchanged = false;
                    try {
                        isDocumentHashUnchanged = ((DBProcessingMetaData)JCasUtil.selectSingle((JCas)jCas, DBProcessingMetaData.class)).getIsDocumentHashUnchanged();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!isDocumentHashUnchanged || !this.skipUnchangedDocuments) {
                        BioCDocument bioCDocument = this.bioCDocumentPopulator.populate(jCas);
                        gnormPlusInputCollection.addDocument(bioCDocument);
                    } else {
                        log.trace("Document with ID {} already exists in the XMI database table with unchanged text contents, skipping GNormPlus processing.", (Object)JCoReTools.getDocId((JCas)jCas));
                    }
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
                            XmiCasSerializer.serialize((CAS)jCas.getCas(), (OutputStream)os);
                        }
                        this.cachedCasData.add(baos.toByteArray());
                        jCas.release();
                    }
                    catch (IOException | SAXException e) {
                        log.error("Error when serializing CAS data for caching purposes.");
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                }
                if (gnormPlusInputCollection.getDocmentCount() > 0) {
                    log.trace("Processing {} documents with GNormPlus.", (Object)gnormPlusInputCollection.getDocmentCount());
                    Path outputFilePath = GNormPlusProcessing.processWithGNormPlus(gnormPlusInputCollection, this.outputDirectory);
                    try {
                        this.bioCCasPopulator = new BioCCasPopulator(outputFilePath, Class.forName(this.outputGeneTypeName).getConstructor(JCas.class));
                        if (this.outputDirectory.isBlank()) {
                            Files.delete(outputFilePath);
                        }
                    }
                    catch (IOException | XMLStreamException e) {
                        log.error("Could not read GNormPlus output from {}", (Object)outputFilePath);
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException e) {
                        log.error("Could not obtain UIMA gene annotation type constructor for class {}", (Object)this.outputGeneTypeName);
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                }
            }
            byte[] currentCasData = this.cachedCasData.get(this.currentCollectionIndex);
            jCas = this.multiplierGetEmptyCas.get();
            try (GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(currentCasData));){
                XmiCasDeserializer.deserialize((InputStream)is, (CAS)jCas.getCas());
            }
            catch (IOException | SAXException e) {
                log.error("Could not deserialize cached CAS data");
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            boolean isDocumentHashUnchanged = false;
            try {
                isDocumentHashUnchanged = ((DBProcessingMetaData)JCasUtil.selectSingle((JCas)jCas, DBProcessingMetaData.class)).getIsDocumentHashUnchanged();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!isDocumentHashUnchanged || !this.skipUnchangedDocuments) {
                this.bioCCasPopulator.populateWithNextDocument(jCas, true);
                this.bioCCasPopulator.clearDocument(this.currentBiocResultCollectionIndex++);
            }
            this.cachedCasData.set(this.currentCollectionIndex, null);
            ++this.currentCollectionIndex;
            if (log.isTraceEnabled()) {
                log.trace("Created multiplier-CAS for document with ID {}", (Object)JCoReTools.getDocId((JCas)jCas));
            }
            return jCas;
        }
        catch (AnalysisEngineProcessException e) {
            log.error("Error while retrieving or processing data for/with GNormPlus", (Throwable)e);
            throw e;
        }
    }

    public boolean hasNext() {
        try {
            return this.currentCollectionIndex < this.cachedCasData.size() || this.baseMultiplierHasNext.get() != false;
        }
        catch (Throwable t) {
            log.error("Could not determine hasNext()", t);
            throw t;
        }
    }
}

