/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.gnp;

import com.pengyifan.bioc.BioCCollection;
import com.pengyifan.bioc.BioCDocument;
import de.julielab.jcore.ae.gnp.GNormPlusProcessing;
import de.julielab.jcore.consumer.gnp.BioCDocumentPopulator;
import de.julielab.jcore.reader.BioCCasPopulator;
import de.julielab.jcore.types.Gene;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe GNormPlus Annotator", description="Wrapper for the JULIE Lab variant of the GNormPlus gene ID mapper.", vendor="JULIE Lab Jena, Germany")
@TypeCapability(inputs={}, outputs={"de.julielab.jcore.types.ConceptMention", "de.julielab.jcore.types.Organism"})
public class GNormPlusAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_ADD_GENES = "AddGenes";
    public static final String DESC_GENE_TYPE_NAME = "The UIMA type denoting gene annotations that should be written into the BioC format when the AddGenes parameter is set to true.";
    public static final String PARAM_GENE_TYPE_NAME = "GeneTypeName";
    public static final String DESC_ADD_GENES = "If set to true, all Gene annotations in the CAS will be added to the BioC documents. The default type used is de.julielab.jcore.types.Gene. This can be changed with the GeneTypeName parameter.";
    public static final String PARAM_GNP_SETUP_FILE = "GNormPlusSetupFile";
    public static final String PARAM_FOCUS_SPECIES = "FocusSpecies";
    public static final String PARAM_OUTPUT_DIR = "OutputDirectory";
    public static final String DESC_GNP_SETUP_FILE = "File path or class path resource path to the setup.txt file for GNormPlus. If not specified, a default setup file is loaded that expects the Dictionary/ directory directly under the working directory, performs gene recognition with the CRF and thus expects the GNormPlus CRF directory directly under the working directory and maps the found genes to NCBI gene IDs for all organisms.";
    public static final String DESC_FOCUS_SPECIES = "If given, all gene mentions are assigned to this NCBI taxonomy ID, i.e. species recognition is omitted.";
    public static final String DESC_OUTPUT_DIR = "Optional. If specified, the GNormPlus output files in BioC format will be saved to the given directory. In this way, this component can be used directly as a BioC XML writer through the GNormPlus algorithm.";
    private static final Logger log = LoggerFactory.getLogger(GNormPlusAnnotator.class);
    @ConfigurationParameter(name="AddGenes", mandatory=false, defaultValue={"false"}, description="If set to true, all Gene annotations in the CAS will be added to the BioC documents. The default type used is de.julielab.jcore.types.Gene. This can be changed with the GeneTypeName parameter.")
    private boolean addGenes;
    @ConfigurationParameter(name="GeneTypeName", mandatory=false, defaultValue={"de.julielab.jcore.types.Gene"}, description="The UIMA type denoting gene annotations that should be written into the BioC format when the AddGenes parameter is set to true.")
    private String geneTypeName;
    @ConfigurationParameter(name="GNormPlusSetupFile", mandatory=false, description="File path or class path resource path to the setup.txt file for GNormPlus. If not specified, a default setup file is loaded that expects the Dictionary/ directory directly under the working directory, performs gene recognition with the CRF and thus expects the GNormPlus CRF directory directly under the working directory and maps the found genes to NCBI gene IDs for all organisms.")
    private String setupFile;
    @ConfigurationParameter(name="FocusSpecies", mandatory=false, description="If given, all gene mentions are assigned to this NCBI taxonomy ID, i.e. species recognition is omitted.")
    private String focusSpecies;
    @ConfigurationParameter(name="OutputDirectory", mandatory=false, description="Optional. If specified, the GNormPlus output files in BioC format will be saved to the given directory. In this way, this component can be used directly as a BioC XML writer through the GNormPlus algorithm.")
    private String outputDirectory;
    private BioCDocumentPopulator bioCDocumentPopulator;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.addGenes = (Boolean)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_ADD_GENES)).orElse(false);
        this.geneTypeName = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_GENE_TYPE_NAME)).orElse(Gene.class.getCanonicalName());
        this.setupFile = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_GNP_SETUP_FILE)).orElse("/de/julielab/jcore/ae/gnp/config/setup_do_ner.txt");
        this.focusSpecies = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_FOCUS_SPECIES)).orElse("");
        this.outputDirectory = (String)Optional.ofNullable(aContext.getConfigParameterValue(PARAM_OUTPUT_DIR)).orElse("");
        try {
            GNormPlusProcessing.initializeGNormPlus(this.setupFile, this.focusSpecies);
        }
        catch (IOException e) {
            log.error("Could not find resource {}", (Object)this.setupFile);
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            this.bioCDocumentPopulator = new BioCDocumentPopulator(this.addGenes, this.geneTypeName);
        }
        catch (ClassNotFoundException e) {
            log.error("Gene annotation class {} could not be found.", (Object)this.geneTypeName, (Object)e);
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            if (!this.outputDirectory.isBlank()) {
                Files.createDirectories(Path.of(this.outputDirectory, new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Could not create the output directory {}", (Object)this.outputDirectory);
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        BioCDocument bioCDocument = this.bioCDocumentPopulator.populate(aJCas);
        BioCCollection bioCCollection = GNormPlusProcessing.createEmptyJulieLabBioCCollection();
        bioCCollection.addDocument(bioCDocument);
        String outputDirectory = this.outputDirectory;
        Path outputFilePath = GNormPlusProcessing.processWithGNormPlus(bioCCollection, outputDirectory);
        try {
            BioCCasPopulator bioCCasPopulator = new BioCCasPopulator(outputFilePath);
            bioCCasPopulator.populateWithNextDocument(aJCas, true);
        }
        catch (IOException | XMLStreamException e) {
            log.error("Could not read GNormPlus output file {}");
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        try {
            if (outputDirectory.isBlank() && Files.exists(outputFilePath, new LinkOption[0])) {
                Files.delete(outputFilePath);
            }
        }
        catch (IOException e) {
            log.error("Could not delete temporary file {}", (Object)outputFilePath);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

