/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.flow.annotationdefined;

import de.julielab.jcore.types.casflow.ToVisit;
import de.julielab.jcore.utility.JCoReTools;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.JCasFlow_ImplBase;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.jcas.JCas;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDefinedFlow
extends JCasFlow_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(AnnotationDefinedFlow.class);
    private String[] toVisitKeys;
    private String[] fixedFlow;
    private int currentPos;
    private String docId;

    public AnnotationDefinedFlow(@Nullable ToVisit toVisit, FlowConstraints flowConstraints, JCas jCas) throws AnalysisEngineProcessException {
        if (!(flowConstraints instanceof FixedFlow)) {
            throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("This flow requires the FixedFlow to determine the default processing order. However, the flow constraints are of type " + flowConstraints.getClass().getCanonicalName()));
        }
        this.fixedFlow = ((FixedFlow)flowConstraints).getFixedFlow();
        if (log.isTraceEnabled()) {
            this.docId = JCoReTools.getDocId((JCas)jCas);
            if (toVisit != null) {
                String[] delegateKeys = toVisit.getDelegateKeys() != null ? toVisit.getDelegateKeys().toArray() : null;
                log.trace("Found ToVisit annotation for document {} with the following component keys: {}", (Object)this.docId, (Object)delegateKeys);
            } else {
                log.trace("Got no ToVisit annotation for document {}, the CAS is routed through the aggregate in the default order.", (Object)this.docId);
            }
        }
        if (toVisit != null && toVisit.getDelegateKeys() != null) {
            Set knownKeys = Arrays.stream(this.fixedFlow).collect(Collectors.toSet());
            this.toVisitKeys = (String[])Arrays.stream(toVisit.getDelegateKeys().toArray()).filter(knownKeys::contains).toArray(String[]::new);
        } else {
            this.toVisitKeys = toVisit != null ? new String[0] : null;
        }
        this.currentPos = 0;
    }

    public Step next() {
        if (this.toVisitKeys == null && this.currentPos < this.fixedFlow.length || this.toVisitKeys != null && this.currentPos < this.toVisitKeys.length) {
            String nextAEKey = this.toVisitKeys != null ? this.toVisitKeys[this.currentPos] : this.fixedFlow[this.currentPos];
            ++this.currentPos;
            log.trace("Next component key to visit for document {}: {}", (Object)this.docId, (Object)nextAEKey);
            return new SimpleStep(nextAEKey);
        }
        log.trace("Flow finished for document {}.", (Object)this.docId);
        return new FinalStep();
    }
}

