/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.flairner;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import de.julielab.ipc.javabridge.Options;
import de.julielab.ipc.javabridge.StdioBridge;
import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.jcore.ae.flairner.FlairNerAnnotator;
import de.julielab.jcore.ae.flairner.NerTaggingResponse;
import de.julielab.jcore.ae.flairner.PythonConnector;
import de.julielab.jcore.ae.flairner.TaggedEntity;
import de.julielab.jcore.ae.flairner.TokenEmbedding;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdioPythonConnector
implements PythonConnector {
    private static final Logger log = LoggerFactory.getLogger(StdioPythonConnector.class);
    private final StdioBridge<byte[]> bridge;

    public StdioPythonConnector(String languageModelPath, String pythonExecutable, FlairNerAnnotator.StoreEmbeddings storeEmbeddings, int gpuNum) throws IOException {
        Options params = new Options(byte[].class);
        params.setExecutable(pythonExecutable);
        params.setExternalProgramReadySignal("Ready for tagging.");
        params.setExternalProgramTerminationSignal("exit");
        params.setTerminationSignalFromErrorStream("SyntaxError");
        String script = IOStreamUtilities.getStringFromInputStream((InputStream)this.getClass().getResourceAsStream("/de/julielab/jcore/ae/flairner/python/nerScript.py"));
        this.bridge = new StdioBridge(params, new String[]{"-u", "-c", script, languageModelPath, storeEmbeddings.name(), String.valueOf(gpuNum)});
    }

    @Override
    public NerTaggingResponse tagSentences(Stream<Sentence> sentences) throws AnalysisEngineProcessException {
        try {
            StringWriter sw = new StringWriter();
            JsonGenerator generator = new JsonFactory().createGenerator((Writer)sw);
            generator.writeStartArray();
            sentences.forEach(sentence -> {
                try {
                    JCas jCas = sentence.getCAS().getJCas();
                    FSIterator tokensInSentence = jCas.getAnnotationIndex(Token.type).subiterator((AnnotationFS)sentence);
                    String tokenizedSentenceText = StreamSupport.stream(Spliterators.spliteratorUnknownSize(tokensInSentence, 0), false).map(Annotation::getCoveredText).collect(Collectors.joining(" "));
                    if (!tokenizedSentenceText.isBlank()) {
                        generator.writeStartObject();
                        generator.writeFieldName("sid");
                        generator.writeString(sentence.getId());
                        generator.writeFieldName("text");
                        generator.writeString(tokenizedSentenceText);
                        generator.writeEndObject();
                    }
                }
                catch (CASException e) {
                    log.error("Could not retrieve the JCas from the CAS", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Could not write JSON", (Throwable)e);
                }
            });
            generator.writeEndArray();
            generator.close();
            ArrayList<TokenEmbedding> embeddings = new ArrayList<TokenEmbedding>();
            Iterator bytesIt = this.bridge.sendAndReceive(sw.toString()).iterator();
            ArrayList<TaggedEntity> taggedEntities = new ArrayList<TaggedEntity>();
            while (bytesIt.hasNext()) {
                byte[] sentenceResponseBytes = (byte[])bytesIt.next();
                ByteBuffer bb = ByteBuffer.wrap(sentenceResponseBytes);
                int numEntities = bb.getInt();
                for (int i = 0; i < numEntities; ++i) {
                    int taggedEntityResponseLength = bb.getInt();
                    byte[] taggedEntityRepsonseBytes = new byte[taggedEntityResponseLength];
                    bb.get(taggedEntityRepsonseBytes);
                    String taggedEntityString = new String(taggedEntityRepsonseBytes, StandardCharsets.UTF_8);
                    String[] taggedEntityRecord = taggedEntityString.split("\\t");
                    taggedEntities.add(new TaggedEntity(taggedEntityRecord[0], taggedEntityRecord[1], Double.valueOf(taggedEntityRecord[2]), Integer.valueOf(taggedEntityRecord[3]), Integer.valueOf(taggedEntityRecord[4])));
                }
                int numEmbeddingVectors = bb.getInt();
                int vectorLength = bb.getInt();
                for (int i = 0; i < numEmbeddingVectors; ++i) {
                    int sentenceIdLength = bb.getInt();
                    byte[] sentenceIdBytes = new byte[sentenceIdLength];
                    bb.get(sentenceIdBytes);
                    String sid = new String(sentenceIdBytes, StandardCharsets.UTF_8);
                    int tokenId = bb.getInt();
                    double[] vector = new double[vectorLength];
                    for (int j = 0; j < vectorLength; ++j) {
                        vector[j] = bb.getDouble();
                    }
                    TokenEmbedding tokenEmbedding = new TokenEmbedding(sid, tokenId, vector);
                    embeddings.add(tokenEmbedding);
                }
            }
            return new NerTaggingResponse(taggedEntities, embeddings);
        }
        catch (InterruptedException e) {
            log.error("Python communication was interrupted", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException occurred", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    @Override
    public void start() throws IOException {
        this.bridge.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        try {
            this.bridge.stop();
        }
        catch (IOException e) {
            log.error("Exception while stopping external process", (Throwable)e);
        }
    }
}

