/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.eventflattener;

import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.GeneralEventMention;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.ext.FlattenedRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"de.julielab.jcore.types.EventMention"}, outputs={"de.julielab.jcore.types.ext.FlattenedRelation"})
public class EventFlattener
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(EventFlattener.class);

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            int flatEventCounter = 0;
            List<EventMention> topEvents = this.determineTopEvents(aJCas);
            for (EventMention topEvent : topEvents) {
                List<EventMention> events = this.collectEventsInTree(topEvent, new ArrayList<EventMention>());
                List<ArgumentMention> arguments = this.collectPrimitiveArguments(topEvent, new ArrayList<ArgumentMention>());
                List<ArgumentMention> agentArguments = null;
                List<ArgumentMention> patientArguments = null;
                switch (topEvent.getSpecificType()) {
                    case "Regulation": 
                    case "Positive_regulation": 
                    case "Negative_regulation": {
                        agentArguments = this.collectAgentArguments(topEvent, new ArrayList<ArgumentMention>());
                        patientArguments = this.collectPatientArguments(topEvent, new ArrayList<ArgumentMention>());
                        break;
                    }
                }
                FSArray flatArgs = this.createFSArrayForList(aJCas, arguments);
                FSArray agentArgs = null != agentArguments ? this.createFSArrayForList(aJCas, agentArguments) : null;
                FSArray patientArgs = null != patientArguments ? this.createFSArrayForList(aJCas, patientArguments) : null;
                FSArray flatEvents = this.createFSArrayForList(aJCas, events);
                FlattenedRelation flattenedRelation = new FlattenedRelation(aJCas, topEvent.getBegin(), topEvent.getEnd());
                flattenedRelation.setRootRelation((GeneralEventMention)topEvent);
                flattenedRelation.setArguments(flatArgs);
                flattenedRelation.setAgents(agentArgs);
                flattenedRelation.setPatients(patientArgs);
                flattenedRelation.setRelations(flatEvents);
                flattenedRelation.setId("FE" + flatEventCounter++);
                flattenedRelation.addToIndexes();
            }
        }
        catch (Exception e) {
            Header header = (Header)aJCas.getAnnotationIndex(Header.type).iterator().next();
            log.error("Exception occurred in document {}: {}", (Object)header.getDocId(), (Object)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private FSArray createFSArrayForList(JCas aJCas, List<? extends Annotation> arguments) {
        FSArray flatArgs = new FSArray(aJCas, arguments.size());
        for (int i = 0; i < arguments.size(); ++i) {
            flatArgs.set(i, (FeatureStructure)arguments.get(i));
        }
        return flatArgs;
    }

    private List<EventMention> collectEventsInTree(EventMention event, ArrayList<EventMention> collector) {
        collector.add(event);
        for (int i = 0; i < event.getArguments().size(); ++i) {
            ArgumentMention arg = event.getArguments(i);
            if (!(arg.getRef() instanceof EventMention)) continue;
            this.collectEventsInTree((EventMention)arg.getRef(), collector);
        }
        return collector;
    }

    private List<ArgumentMention> collectPatientArguments(EventMention topEvent, ArrayList<ArgumentMention> collector) {
        for (int i = 0; i < topEvent.getArguments().size(); ++i) {
            ArgumentMention arg = topEvent.getArguments(i);
            if (!arg.getRole().equals("Theme")) continue;
            if (arg.getRef() instanceof EventMention) {
                this.collectPrimitiveArguments((EventMention)arg.getRef(), collector);
                continue;
            }
            collector.add(arg);
        }
        return collector;
    }

    private List<ArgumentMention> collectAgentArguments(EventMention topEvent, ArrayList<ArgumentMention> collector) {
        for (int i = 0; i < topEvent.getArguments().size(); ++i) {
            ArgumentMention arg = topEvent.getArguments(i);
            if (!arg.getRole().equals("Cause")) continue;
            if (arg.getRef() instanceof EventMention) {
                this.collectPrimitiveArguments((EventMention)arg.getRef(), collector);
                continue;
            }
            collector.add(arg);
        }
        return collector;
    }

    private List<ArgumentMention> collectPrimitiveArguments(EventMention topEvent, List<ArgumentMention> collector) {
        for (int i = 0; i < topEvent.getArguments().size(); ++i) {
            ArgumentMention arg = topEvent.getArguments(i);
            if (arg.getRef() instanceof EventMention) {
                this.collectPrimitiveArguments((EventMention)arg.getRef(), collector);
                continue;
            }
            collector.add(arg);
        }
        return collector;
    }

    private List<EventMention> determineTopEvents(JCas aJCas) {
        ArrayList<EventMention> topEvents = new ArrayList<EventMention>();
        HashSet<EventMention> nonTopEvents = new HashSet<EventMention>();
        for (EventMention em : aJCas.getAnnotationIndex(EventMention.type)) {
            for (int i = 0; i < em.getArguments().size(); ++i) {
                ArgumentMention arg = em.getArguments(i);
                if (!(arg.getRef() instanceof EventMention)) continue;
                nonTopEvents.add((EventMention)arg.getRef());
            }
        }
        for (EventMention em : aJCas.getAnnotationIndex(EventMention.type)) {
            if (nonTopEvents.contains(em)) continue;
            topEvents.add(em);
        }
        return topEvents;
    }
}

