/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.db;

import de.julielab.jcore.reader.db.DBSubsetReader;
import de.julielab.jcore.types.ext.DBProcessingMetaData;
import de.julielab.xmlData.dataBase.CoStoSysConnection;
import de.julielab.xmlData.dataBase.DBCIterator;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import de.julielab.xmlData.dataBase.util.TableSchemaMismatchException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Database Reader", description="A collection reader that fetches documents from a PostgreSQL database. It is an abstract class and must be extended to actually populate CAS instances. It works with the corpus storage system (CoStoSys), thus subset tables may be specified to read from in the 'Table' parameter. Then, the reader will mark batches of IDs read from the subset as being 'in process', allowing multiple DBReaders in different pipelines to be synchronized and not read documents multiple times. Additional tables can be specified that will be joined to the main document database. This is used to load annotations that have been stored in separate tables. The jcore-xmi-db-writer is able to write such annotation tables and the jcore-xmi-db-reader implements the assembly of such distributed annotation data. All mentioned components are part of the Jena Document Information System, JeDIS, for document annotation and management.", vendor="JULIE Lab Jena, Germany", copyright="JULIE Lab Jena, Germany")
public abstract class DBReader
extends DBSubsetReader {
    private static final Logger log = LoggerFactory.getLogger(DBReader.class);
    @ConfigurationParameter(name="Timestamp", mandatory=false, description="PostgreSQL timestamp expression that is evaluated against the data table. The data table schema, which must be the active data table schema in the CoStoSys configuration as always, must specify a single timestamp field for this parameter to work. Only data rows with a timestamp value larger than the given timestamp expression will be processed. Note that when reading from a subset table, there may be subset rows indicated to be in process which are finally not read from the data table. This is an implementational shortcoming and might be addressed if respective feature requests are given through the JULIE Lab GitHub page or JCoRe issues.")
    protected String dataTimestamp;
    private RetrievingThread retriever;
    private DBCIterator<byte[][]> xmlBytes;

    public static String setDBProcessingMetaData(DataBaseConnector dbc, boolean readDataTable, String tableName, byte[][] data, JCas cas) {
        String pkString = null;
        JCasUtil.select((JCas)cas, DBProcessingMetaData.class).forEach(x -> x.removeFromIndexes());
        DBProcessingMetaData dbMetaData = new DBProcessingMetaData(cas);
        List pkIndices = dbc.getPrimaryKeyIndices();
        StringArray pkArray = new StringArray(cas, pkIndices.size());
        for (int i = 0; i < pkIndices.size(); ++i) {
            Integer index = (Integer)pkIndices.get(i);
            String pkElementValue = new String(data[index], Charset.forName("UTF-8"));
            pkArray.set(i, pkElementValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting primary key to {}", (Object)Arrays.toString(pkArray.toArray()));
        }
        dbMetaData.setPrimaryKey(pkArray);
        if (!readDataTable) {
            dbMetaData.setSubsetTable(tableName.contains(".") ? tableName : dbc.getActivePGSchema() + "." + tableName);
        }
        dbMetaData.addToIndexes();
        return pkString;
    }

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.dataTimestamp = (String)this.getConfigParameterValue("Timestamp");
        if (this.readDataTable.booleanValue() && this.hasNext) {
            log.debug("Querying data table {} with schema {} and where condition {}", new Object[]{this.tableName, this.dbc.getActiveTableSchema(), this.whereCondition});
            this.xmlBytes = this.dbc.queryDataTable(this.tableName, this.whereCondition);
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.hasNext;
    }

    public byte[][] getNextArtifactData() throws CollectionException {
        log.trace("Fetching next document from the current database batch");
        byte[][] next = null;
        next = this.readDataTable != false ? this.getNextFromDataTable() : this.getNextFromSubset();
        if (next != null) {
            ++this.processedDocuments;
        }
        return next;
    }

    private byte[][] getNextFromDataTable() {
        this.hasNext = false;
        byte[][] next = (byte[][])this.xmlBytes.next();
        if (this.processedDocuments < this.totalDocumentCount - 1) {
            this.hasNext = this.xmlBytes.hasNext();
            if (!this.hasNext) {
                this.close();
            }
        }
        return next;
    }

    private byte[][] getNextFromSubset() {
        log.trace("Reading in subset table mode.");
        byte[][] next = null;
        if (this.retriever == null) {
            log.trace("Creating new RetrievingThread for fetching the first document batch");
            this.retriever = new RetrievingThread();
            this.xmlBytes = this.retriever.getDocuments();
            if (this.fetchIdsProactively.booleanValue()) {
                log.trace("Creating background RetrievingThread to immediately fetch the next document batch");
                this.retriever = new RetrievingThread();
            }
        }
        if (this.xmlBytes.hasNext()) {
            log.debug("Returning next document.");
            next = (byte[][])this.xmlBytes.next();
        }
        if (!this.xmlBytes.hasNext()) {
            this.xmlBytes = this.retriever.getDocuments();
            if (!this.xmlBytes.hasNext()) {
                log.debug("No more documents, settings 'hasNext' to false.");
                this.hasNext = false;
                this.close();
            } else if (this.fetchIdsProactively.booleanValue()) {
                log.trace("Creating background RetrievingThread to immediately fetch the next document batch");
                this.retriever = new RetrievingThread();
            }
        }
        return next;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.processedDocuments, this.totalDocumentCount, "entities", true)};
    }

    public void close() {
        log.debug("Closing {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        if (this.xmlBytes != null) {
            this.xmlBytes.close();
        }
        this.dbc.close();
    }

    protected abstract String getReaderComponentName();

    protected class RetrievingThread
    extends Thread {
        private List<Object[]> ids;
        private DBCIterator<byte[][]> documents;

        public RetrievingThread() {
            if (DBReader.this.fetchIdsProactively.booleanValue()) {
                log.debug("Fetching new documents in a background thread.");
                this.setName("DBReader RetrievingThread");
                this.start();
            }
        }

        @Override
        public void run() {
            int limit = Math.min(DBReader.this.batchSize, DBReader.this.totalDocumentCount - DBReader.this.numberFetchedDocIDs);
            try {
                CoStoSysConnection ignored = DBReader.this.dbc.obtainOrReserveConnection();
                Object object = null;
                try {
                    this.ids = DBReader.this.dbc.retrieveAndMark(DBReader.this.tableName, DBReader.this.getReaderComponentName(), DBReader.this.hostName, DBReader.this.pid, limit, DBReader.this.selectionOrder);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ignored != null) {
                        if (object != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
                if (log.isTraceEnabled()) {
                    ArrayList<String> idStrings = new ArrayList<String>();
                    for (Object[] o : this.ids) {
                        ArrayList<String> pkElements = new ArrayList<String>();
                        for (int i = 0; i < o.length; ++i) {
                            Object object2 = o[i];
                            pkElements.add(String.valueOf(object2));
                        }
                        idStrings.add(StringUtils.join(pkElements, (String)"-"));
                    }
                    log.trace("Reserved the following document IDs for processing: " + idStrings);
                }
            }
            catch (TableSchemaMismatchException e) {
                log.error("Table schema mismatch: The active table schema {} specified in the CoStoSys configuration file {} does not match the columns in the subset table {}: {}", new Object[]{DBReader.this.dbc.getActiveTableSchema(), DBReader.this.costosysConfig, DBReader.this.tableName, e.getMessage()});
                throw new IllegalArgumentException(e);
            }
            DBReader.this.numberFetchedDocIDs += this.ids.size();
            log.debug("Retrieved {} document IDs to fetch from the database.", (Object)this.ids.size());
            if (this.ids.size() > 0) {
                log.debug("Fetching {} documents from the database.", (Object)this.ids.size());
                if (DBReader.this.dataTimestamp == null) {
                    if (!DBReader.this.joinTables) {
                        log.trace("Fetching data from the data table {} without additional tables.", (Object)DBReader.this.dataTable);
                        this.documents = DBReader.this.dbc.retrieveColumnsByTableSchema(this.ids, DBReader.this.dataTable);
                    } else {
                        log.trace("Fetching data by joining tables {}. The used table schemas are {}.", (Object)DBReader.this.tables, (Object)DBReader.this.schemas);
                        this.documents = DBReader.this.dbc.retrieveColumnsByTableSchema(this.ids, DBReader.this.tables, DBReader.this.schemas);
                    }
                } else {
                    log.trace("Fetching data from data table {} that is newer than timestamp {}", (Object)DBReader.this.dataTable, (Object)DBReader.this.dataTimestamp);
                    this.documents = DBReader.this.dbc.queryWithTime(this.ids, DBReader.this.dataTable, DBReader.this.dataTimestamp);
                }
            } else {
                log.debug("No unfetched documents left.");
                this.documents = new DBCIterator<byte[][]>(){

                    public boolean hasNext() {
                        return false;
                    }

                    public byte[][] next() {
                        return null;
                    }

                    public void remove() {
                    }

                    public void close() {
                    }
                };
            }
        }

        public DBCIterator<byte[][]> getDocuments() {
            if (!DBReader.this.fetchIdsProactively.booleanValue()) {
                log.debug("Fetching new documents (without employing a background thread).");
                this.run();
            }
            try {
                log.debug("Waiting for the background thread to finish fetching documents to return them.");
                this.join();
                return this.documents;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

