/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.db;

import de.julielab.jcore.types.casmultiplier.RowBatch;
import de.julielab.xmlData.dataBase.DBCIterator;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import de.julielab.xmlData.dataBase.util.UnobtainableConnectionException;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;

@ResourceMetaData(name="JCoRe Abstract Database Multiplier", description="A multiplier that receives document IDs to read from a database table from the DBMultiplierReader. The reader also delivers the path to the corpus storage system (CoStoSys) configuration and additional tables for joining with the main data table. This multiplier class is abstract and cannot be used directly.Extending classes must implement the next() method to actually read documents from the database and populate CASes with them. This component is a part of the Jena Document Information System, JeDIS.", vendor="JULIE Lab Jena, Germany", copyright="JULIE Lab Jena, Germany")
@OperationalProperties(outputsNewCases=true)
public abstract class DBMultiplier
extends JCasMultiplier_ImplBase {
    protected DataBaseConnector dbc;
    protected DBCIterator<byte[][]> documentDataIterator;
    protected String[] tables;
    protected String[] schemaNames;
    protected String tableName;
    protected boolean readDataTable;
    protected String dataTable;
    protected boolean initialized;
    private StringArray pkArray;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.initialized = false;
    }

    private DataBaseConnector getDataBaseConnector(String costosysConfig) throws AnalysisEngineProcessException {
        DataBaseConnector dbc;
        try {
            dbc = new DataBaseConnector(costosysConfig);
        }
        catch (FileNotFoundException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        return dbc;
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        RowBatch rowbatch = (RowBatch)JCasUtil.selectSingle((JCas)aJCas, RowBatch.class);
        this.tables = rowbatch.getTables().toStringArray();
        this.schemaNames = rowbatch.getTableSchemas().toStringArray();
        this.tableName = this.tables[0];
        if (!this.initialized) {
            String referencedTable;
            if (this.dbc == null) {
                this.dbc = this.getDataBaseConnector(rowbatch.getCostosysConfiguration());
            }
            try {
                referencedTable = this.dbc.withConnectionQueryString(c -> c.getReferencedTable(rowbatch.getTables(0)));
            }
            catch (UnobtainableConnectionException e) {
                throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("The maximum database connection pool size is smaller than 2. However, when reading from database tables, one connection is required the whole time to read documents via cursor from the database and another connection is required to do data consistency checks. Set the number of active connections in the CoStoSys configuration file at least to 2.", e));
            }
            this.readDataTable = referencedTable == null;
            this.dataTable = referencedTable == null ? this.tables[0] : referencedTable;
            this.initialized = true;
        }
        ArrayList<String[]> documentIdsForQuery = new ArrayList<String[]>();
        FSArray identifiers = rowbatch.getIdentifiers();
        for (int i = 0; i < identifiers.size(); ++i) {
            StringArray primaryKey = (StringArray)identifiers.get(i);
            documentIdsForQuery.add(primaryKey.toArray());
        }
        this.documentDataIterator = this.dbc.retrieveColumnsByTableSchema(documentIdsForQuery, this.tables, this.schemaNames);
    }

    public boolean hasNext() {
        return this.documentDataIterator != null && this.documentDataIterator.hasNext();
    }
}

