/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.checkpoint;

import de.julielab.jcore.ae.checkpoint.DocumentId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentReleaseCheckpoint {
    public static final String SYNC_PARAM_DESC = "If set, the value of this parameter is used to synchronize the 'processed' mark in the subset table documents processed by the pipeline. This is useful when document data is sent batchwise to the database by multiple components: In the case of a crash or manual cancellation of a pipeline run without synchronization is might happen that some components have sent their data and others haven't at the time of termination. To avoid an inconsistent database state,a document will only be marked as finished processed in the JeDIS subset table if all synchronized components in the pipeline have released the document. This is done by the DBCheckpointAE which must be at the end of the pipeline and have the 'IndicateFinished' parameter set to 'true'. Synchronized components are those that disclose this parameter and have a value set to it.";
    public static final String PARAM_JEDIS_SYNCHRONIZATION_KEY = "JedisSynchronizationKey";
    private static final Logger log = LoggerFactory.getLogger(DocumentReleaseCheckpoint.class);
    private static DocumentReleaseCheckpoint checkpoint;
    private Map<DocumentId, Set<String>> releasedDocuments = new HashMap<DocumentId, Set<String>>();
    private Set<String> registeredComponents = new HashSet<String>();
    private long lastwarning = 1000L;

    private DocumentReleaseCheckpoint() {
    }

    public static DocumentReleaseCheckpoint get() {
        if (checkpoint == null) {
            checkpoint = new DocumentReleaseCheckpoint();
        }
        return checkpoint;
    }

    public void register(String componentKey) {
        this.registeredComponents.add(componentKey);
    }

    public void unregister(String componentKey) {
        this.registeredComponents.remove(componentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(String componentKey, Stream<DocumentId> releasedDocumentIds) {
        if (!this.registeredComponents.contains(componentKey)) {
            throw new IllegalArgumentException("No component is registered for key " + componentKey);
        }
        Map<DocumentId, Set<String>> map = this.releasedDocuments;
        synchronized (map) {
            releasedDocumentIds.forEach(d -> this.releasedDocuments.compute((DocumentId)d, (k, v) -> {
                if (v == null) {
                    HashSet<String> ret = new HashSet<String>();
                    ret.add(componentKey);
                    return ret;
                }
                v.add(componentKey);
                return v;
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DocumentId> getReleasedDocumentIds() {
        Set<DocumentId> returnedIds;
        Map<DocumentId, Set<String>> map = this.releasedDocuments;
        synchronized (map) {
            log.trace("The following {} components are registered for document release: {}", (Object)this.getNumberOfRegisteredComponents(), this.registeredComponents);
            log.trace("Released document counts: {}", this.releasedDocuments);
            returnedIds = this.releasedDocuments.keySet().stream().filter(k -> this.releasedDocuments.get(k).containsAll(this.registeredComponents)).collect(Collectors.toSet());
            log.trace("Final Document IDs to release: {}", returnedIds);
            returnedIds.forEach(id -> this.releasedDocuments.remove(id));
        }
        log.debug("Returning {} documents released by all registered components. {} document IDs remain that have not yet been released by all registered components.", (Object)returnedIds.size(), (Object)this.releasedDocuments.size());
        if ((long)this.releasedDocuments.size() > this.lastwarning) {
            log.warn("The number of document IDs that have not been released by all registered components has grown to {}. If it does not decrease again, there is likely an errorneous component which does not release its documents. Currently registered components: {}", (Object)this.releasedDocuments.size(), this.registeredComponents);
            this.lastwarning *= 2L;
        } else if (this.releasedDocuments.size() < 50) {
            this.lastwarning = 1000L;
        }
        return returnedIds;
    }

    public int getNumberOfRegisteredComponents() {
        return this.registeredComponents.size();
    }
}

