/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.ct.ctmodel;

import de.julielab.jcore.reader.ct.ctmodel.ClinicalTrial;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ClinicalTrialXmlHandler
extends DefaultHandler {
    public static Pattern INCL_EXCL_PATTERN = Pattern.compile("(?:[Ii]nclusion [Cc]riteria:?)?(.+?)(?:[Ee]xclusion [Cc]riteria:?(.+))?$");
    private static final String TAG_START = "clinical_study";
    private static final String TAG_ID = "nct_id";
    private final Stack<String> tagsStack = new Stack();
    private final StringBuilder tempVal = new StringBuilder();
    private ClinicalTrial clinicalTrial;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.pushTag(qName);
        this.tempVal.setLength(0);
        if (TAG_START.equalsIgnoreCase(qName)) {
            this.clinicalTrial = new ClinicalTrial();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String tag = this.peekTag();
        if (!qName.equals(tag)) {
            throw new InternalError();
        }
        this.popTag();
        String parentTag = this.peekTag();
        if (tag.equalsIgnoreCase(TAG_ID)) {
            this.clinicalTrial.id = this.tempVal.toString().trim();
        }
        if (tag.equalsIgnoreCase("brief_title")) {
            this.clinicalTrial.brief_title = this.tempVal.toString().trim();
        }
        if (tag.equalsIgnoreCase("official_title")) {
            this.clinicalTrial.official_title = this.tempVal.toString().trim();
        }
        if (tag.equalsIgnoreCase("textblock") && parentTag.equalsIgnoreCase("brief_summary")) {
            this.clinicalTrial.summary = ClinicalTrialXmlHandler.cleanup(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("textblock") && parentTag.equalsIgnoreCase("detailed_description")) {
            this.clinicalTrial.description = ClinicalTrialXmlHandler.cleanup(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("study_type")) {
            this.clinicalTrial.studyType = this.tempVal.toString().trim();
        }
        if (tag.equalsIgnoreCase("intervention_model") && parentTag.equalsIgnoreCase("study_design_info")) {
            this.clinicalTrial.interventionModel = this.tempVal.toString().trim();
        }
        if (tag.equalsIgnoreCase("primary_purpose") && parentTag.equalsIgnoreCase("study_design_info")) {
            this.clinicalTrial.primaryPurpose = this.tempVal.toString().trim();
        }
        if (tag.equalsIgnoreCase("measure") && ClinicalTrialXmlHandler.isOutcome(parentTag)) {
            this.clinicalTrial.outcomeMeasures.add(ClinicalTrialXmlHandler.cleanup(this.tempVal.toString().trim()));
        }
        if (tag.equalsIgnoreCase("description") && ClinicalTrialXmlHandler.isOutcome(parentTag)) {
            this.clinicalTrial.outcomeDescriptions.add(ClinicalTrialXmlHandler.cleanup(this.tempVal.toString().trim()));
        }
        if (tag.equalsIgnoreCase("condition")) {
            this.clinicalTrial.conditions.add(ClinicalTrialXmlHandler.cleanup(this.tempVal.toString().trim()));
        }
        if (tag.equalsIgnoreCase("intervention_type") && parentTag.equalsIgnoreCase("intervention")) {
            this.clinicalTrial.interventionTypes.add(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("intervention_name") && parentTag.equalsIgnoreCase("intervention")) {
            this.clinicalTrial.interventionNames.add(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("description") && parentTag.equalsIgnoreCase("arm_group")) {
            this.clinicalTrial.armGroupDescriptions.add(ClinicalTrialXmlHandler.cleanup(this.tempVal.toString().trim()));
        }
        if (tag.equalsIgnoreCase("gender")) {
            this.clinicalTrial.sex = ClinicalTrialXmlHandler.parseSex(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("minimum_age")) {
            this.clinicalTrial.minAge = ClinicalTrialXmlHandler.parseMinimumAge(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("maximum_age")) {
            this.clinicalTrial.maxAge = ClinicalTrialXmlHandler.parseMaximumAge(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("criteria")) {
            this.clinicalTrial.inclusion = ClinicalTrialXmlHandler.parseInclusion(this.tempVal.toString().trim());
            this.clinicalTrial.exclusion = ClinicalTrialXmlHandler.parseExclusion(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("keyword")) {
            this.clinicalTrial.keywords.add(this.tempVal.toString().trim());
        }
        if (tag.equalsIgnoreCase("mesh_term")) {
            this.clinicalTrial.meshTags.add(this.tempVal.toString().trim());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.tempVal.append(ch, start, length);
    }

    @Override
    public void startDocument() {
        this.pushTag("");
    }

    public ClinicalTrial getClinicalTrial() {
        return this.clinicalTrial;
    }

    private void pushTag(String tag) {
        this.tagsStack.push(tag);
    }

    private String popTag() {
        return this.tagsStack.pop();
    }

    private String peekTag() {
        return this.tagsStack.peek();
    }

    private static Set<String> parseSex(String sex) {
        HashSet<String> sexSet = new HashSet<String>();
        try {
            switch (sex.toLowerCase()) {
                case "male": {
                    sexSet.add("male");
                    break;
                }
                case "female": {
                    sexSet.add("female");
                    break;
                }
                case "all": {
                    sexSet.add("male");
                    sexSet.add("female");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid sex: " + sex);
                }
            }
            return sexSet;
        }
        catch (Exception e) {
            sexSet.add("male");
            sexSet.add("female");
            return sexSet;
        }
    }

    private static int parseMinimumAge(String age) {
        try {
            return Integer.parseInt(age.replaceAll("[^0-9]+", ""));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int parseMaximumAge(String age) {
        try {
            return Integer.parseInt(age.replaceAll("[^0-9]+", ""));
        }
        catch (Exception e) {
            return 100;
        }
    }

    private static String parseInclusion(String inclusionExclusion) {
        try {
            Matcher m = INCL_EXCL_PATTERN.matcher(ClinicalTrialXmlHandler.cleanup(inclusionExclusion));
            m.find();
            return m.group(1);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String parseExclusion(String inclusionExclusion) {
        try {
            Matcher m = INCL_EXCL_PATTERN.matcher(ClinicalTrialXmlHandler.cleanup(inclusionExclusion));
            m.find();
            return m.group(2);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static boolean isOutcome(String tag) {
        return tag.equalsIgnoreCase("primary_outcome") || tag.equalsIgnoreCase("secondary_outcome") || tag.equalsIgnoreCase("other_outcome");
    }

    private static String cleanup(String text) {
        text = text.replace("\n", "").replace("\r", "");
        text = text.replace("\t", "");
        text = text.trim().replaceAll(" +", " ");
        return text;
    }
}

