/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.ct;

import de.julielab.jcore.reader.ct.ctmodel.ClinicalTrial;
import de.julielab.jcore.types.Keyword;
import de.julielab.jcore.types.MeshHeading;
import de.julielab.jcore.types.ct.ArmGroupDescription;
import de.julielab.jcore.types.ct.BriefTitle;
import de.julielab.jcore.types.ct.Condition;
import de.julielab.jcore.types.ct.Description;
import de.julielab.jcore.types.ct.Exclusion;
import de.julielab.jcore.types.ct.Header;
import de.julielab.jcore.types.ct.Inclusion;
import de.julielab.jcore.types.ct.InterventionName;
import de.julielab.jcore.types.ct.InterventionType;
import de.julielab.jcore.types.ct.OfficialTitle;
import de.julielab.jcore.types.ct.OutcomeDescription;
import de.julielab.jcore.types.ct.OutcomeMeasure;
import de.julielab.jcore.types.ct.StudyDesignInfo;
import de.julielab.jcore.types.ct.Summary;
import de.julielab.jcore.types.pubmed.ManualDescriptor;
import de.julielab.jcore.utility.JCoReTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Clinical Trials Reader", description="This component reads the XML format provided by ClinicalTrials.gov. To this end, the JCoRe type system contains a number of types specifically created for this kind of document. Note that the CAS text created by this reader might be confusing without checking the corresponding annotations. This is due to the fact that the CT XML contains multiple enumerations which are not very well reflected in plain text. Also, enumerations with subitems, such as the outcomes, are not displayed in the expected groups of items. Instead, each item type is displayed separately. This could be changed, if necessary. Since all items are correctly annotated by their category, this might not even be an issue, depending on the downstream tasks.")
public class ClinicalTrialsReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_INPUT_DIR = "InputDirectory";
    public static final String PARAM_FILES = "FileNames";
    private static final Logger log = LoggerFactory.getLogger(ClinicalTrialsReader.class);
    @ConfigurationParameter(name="InputDirectory", description="The root directory that contains the clinical trials. The reader supports a subdirectory structure where the actual XML documents are located on deeper levels.")
    private File inputDirectory;
    @ConfigurationParameter(name="FileNames", mandatory=false, description="For debugging: Restrict the documents read to the given document file names.")
    private String[] fileNames;
    private Iterator<File> files;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.inputDirectory = new File((String)context.getConfigParameterValue(PARAM_INPUT_DIR));
        this.fileNames = (String[])context.getConfigParameterValue(PARAM_FILES);
        try {
            this.files = this.readFiles(this.inputDirectory);
        }
        catch (IOException e) {
            log.error("Could not read clinical trials files", (Throwable)e);
            throw new ResourceInitializationException((Throwable)e);
        }
        log.info("{}: {}", (Object)PARAM_INPUT_DIR, (Object)this.inputDirectory);
        log.info("{}: {}", (Object)PARAM_FILES, (Object)this.fileNames);
    }

    private Iterator<File> readFiles(File inputDirectory) throws IOException {
        ArrayList files = new ArrayList(250000);
        Stream<Path> pathStream = Files.walk(inputDirectory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        if (this.fileNames != null && this.fileNames.length > 0) {
            HashSet<String> idset = new HashSet<String>(Arrays.asList(this.fileNames));
            pathStream = pathStream.filter(f -> idset.contains(f.toFile().getName()));
        }
        pathStream.forEach(f -> files.add(f.toFile()));
        return files.iterator();
    }

    public void getNext(JCas jCas) {
        if (this.files.hasNext()) {
            File file = this.files.next();
            try {
                StringBuilder sb = new StringBuilder();
                ClinicalTrial ct = ClinicalTrial.fromXml(file.getAbsolutePath());
                this.addHeader(jCas, ct);
                this.addManualDescriptor(jCas, ct);
                this.addAnnotatedText(sb, ct.brief_title, (Annotation)new BriefTitle(jCas));
                this.addAnnotatedText(sb, ct.official_title, (Annotation)new OfficialTitle(jCas));
                this.addAnnotatedText(sb, ct.summary, (Annotation)new Summary(jCas));
                this.addAnnotatedText(sb, ct.description, (Annotation)new Description(jCas));
                for (int i = 0; i < ct.outcomeMeasures.size(); ++i) {
                    String outcomeMeasure = ct.outcomeMeasures.get(i);
                    this.addAnnotatedText(sb, outcomeMeasure, (Annotation)new OutcomeMeasure(jCas));
                    if (i >= ct.outcomeDescriptions.size()) continue;
                    String outcomeDescription = ct.outcomeDescriptions.get(i);
                    this.addAnnotatedText(sb, outcomeDescription, (Annotation)new OutcomeDescription(jCas));
                }
                for (String condition : ct.conditions) {
                    this.addAnnotatedText(sb, condition, (Annotation)new Condition(jCas));
                }
                for (int i = 0; i < ct.interventionTypes.size(); ++i) {
                    String interventionType = ct.interventionTypes.get(i);
                    String interventionName = ct.interventionNames.get(i);
                    this.addAnnotatedText(sb, interventionType, (Annotation)new InterventionType(jCas));
                    this.addAnnotatedText(sb, interventionName, (Annotation)new InterventionName(jCas));
                }
                for (String armGroupDesc : ct.armGroupDescriptions) {
                    this.addAnnotatedText(sb, armGroupDesc, (Annotation)new ArmGroupDescription(jCas));
                }
                this.addAnnotatedText(sb, ct.inclusion, (Annotation)new Inclusion(jCas));
                this.addAnnotatedText(sb, ct.exclusion, (Annotation)new Exclusion(jCas));
                jCas.setDocumentText(sb.toString());
            }
            catch (Throwable t) {
                log.error("Exception occurred when reading file {}", (Object)file, (Object)t);
            }
        }
    }

    private void addManualDescriptor(JCas jCas, ClinicalTrial ct) {
        ManualDescriptor md = null;
        if (!ct.meshTags.isEmpty() || !ct.keywords.isEmpty()) {
            md = new ManualDescriptor(jCas);
        }
        for (String meshTag : ct.meshTags) {
            MeshHeading mh = new MeshHeading(jCas);
            mh.setDescriptorName(meshTag);
            md.setMeSHList(JCoReTools.addToFSArray((FSArray)md.getMeSHList(), (FeatureStructure)mh, (int)1));
        }
        for (String keyword : ct.keywords) {
            Keyword kw = new Keyword(jCas);
            kw.setName(keyword);
            md.setKeywordList(JCoReTools.addToFSArray((FSArray)md.getKeywordList(), (FeatureStructure)kw, (int)1));
        }
        if (md != null) {
            md.addToIndexes();
        }
    }

    private Annotation addAnnotatedText(StringBuilder sb, String text, Annotation annotation) {
        annotation.setBegin(sb.length());
        sb.append(text);
        annotation.setEnd(sb.length());
        annotation.addToIndexes();
        sb.append(System.getProperty("line.separator"));
        return annotation;
    }

    private void addHeader(JCas jCas, ClinicalTrial ct) {
        Header header = new Header(jCas);
        header.setDocId(ct.id);
        header.setStudyType(ct.studyType);
        header.setMinimumAge(ct.minAge);
        header.setMaximumAge(ct.maxAge);
        StudyDesignInfo sdi = new StudyDesignInfo(jCas);
        sdi.setInterventionModel(ct.interventionModel);
        sdi.setPrimaryPurpose(ct.primaryPurpose);
        header.setStudyDesignInfo(sdi);
        if (ct.sex != null) {
            StringArray sex = new StringArray(jCas, 0);
            for (String s : ct.sex) {
                sex = JCoReTools.addToStringArray((StringArray)sex, (String)s);
            }
            header.setGender(sex);
        }
        header.addToIndexes();
    }

    public void close() {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(0, 0, "TODO")};
    }

    public boolean hasNext() {
        return this.files.hasNext();
    }
}

