/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.coreference;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.types.CorefExpression;
import de.julielab.jcore.types.CorefRelation;
import de.julielab.jcore.utility.JCoReTools;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@ResourceMetaData(name="JCoRe Coreference Writer", description="Writes co-reference annotation to a text file.")
public class CoreferenceWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUTFILE = "OutputFile";
    @ConfigurationParameter(name="OutputFile")
    private String outputFile;
    private OutputStream os;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.outputFile = (String)aContext.getConfigParameterValue(PARAM_OUTPUTFILE);
        try {
            this.os = FileUtilities.getOutputStreamToFile((File)new File(this.outputFile));
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            String pubmedId = JCoReTools.getDocId((JCas)jcas);
            FSIterator it = jcas.getAnnotationIndex(CorefRelation.type).iterator();
            int relcount = 0;
            while (it.hasNext()) {
                Iterator antecedentsIt;
                CorefRelation rel = (CorefRelation)it.next();
                CorefExpression anaphora = rel.getAnaphora();
                String abbrId = "Ana" + relcount;
                IOUtils.write((String)(String.join((CharSequence)"\t", pubmedId, abbrId, String.valueOf(anaphora.getBegin()), String.valueOf(anaphora.getEnd())) + "\n"), (OutputStream)this.os, (String)"UTF-8");
                Iterator iterator = antecedentsIt = rel.getAntecedents() != null ? rel.getAntecedents().iterator() : null;
                while (antecedentsIt != null && antecedentsIt.hasNext()) {
                    CorefExpression antecedent = (CorefExpression)antecedentsIt.next();
                    if (antecedent == null) continue;
                    String antecedentGroup = "Ant" + relcount;
                    IOUtils.write((String)(String.join((CharSequence)"\t", pubmedId, antecedentGroup, String.valueOf(antecedent.getBegin()), String.valueOf(antecedent.getEnd())) + "\n"), (OutputStream)this.os, (String)"UTF-8");
                }
                ++relcount;
            }
        }
        catch (IOException | CASRuntimeException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.os.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

