/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.biosem;

import de.julielab.jcore.ae.biosem.DBUtilsProvider;
import java.util.Properties;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.DBUtils;

public class DBUtilsProviderImpl
implements DBUtilsProvider {
    private static final Logger log = LoggerFactory.getLogger(DBUtilsProviderImpl.class);
    public static final String CONFIG_TRAINED_DB = "biosem.db.trained.url";
    private DBUtils trainedDb;
    private boolean dbClosed = false;

    public void load(DataResource aData) throws ResourceInitializationException {
        Properties config = new Properties();
        try {
            config.load(aData.getInputStream());
            String dbName = config.getProperty(CONFIG_TRAINED_DB);
            if (null == dbName) {
                throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The passed configuration file at " + aData.getUri() + " does define the property \"" + CONFIG_TRAINED_DB + "\" for the trained BioSem database"));
            }
            String protocol = "file";
            String dbPath = dbName;
            if (dbName.contains(":")) {
                protocol = dbName.substring(0, dbName.indexOf(58));
                dbPath = dbName.substring(dbName.indexOf(58) + 1);
            }
            log.info("Trying to find trained BioSem database using protocol {} at location {}.", (Object)protocol, (Object)dbPath);
            this.trainedDb = new DBUtils(dbPath, protocol, "readonly=true");
            this.trainedDb.openDB();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    @Override
    public DBUtils getTrainedDatabase() {
        return this.trainedDb;
    }

    @Override
    public synchronized void closeDatabase() {
        if (!this.dbClosed) {
            this.trainedDb.closeDB();
            this.dbClosed = true;
        }
    }
}

