/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.biosem;

import corpora.DataLoader;
import de.julielab.jcore.ae.biosem.DBUtilsProvider;
import de.julielab.jcore.ae.biosem.UnknownProteinIdException;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.EventTrigger;
import de.julielab.jcore.types.Gene;
import de.julielab.jcore.types.Header;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relations.EventExtraction;
import relations.PData;
import relations.Word;
import utils.BioSemException;
import utils.DBUtils;

public class BioSemEventAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(BioSemEventAnnotator.class);
    public static final String RESOURCE_TRAINED_DB = "TrainedDB";
    private DataLoader loader;
    private DBUtils trainedDb;
    @ExternalResource(key="TrainedDB", mandatory=true)
    private DBUtilsProvider dbUtilsProvider;
    private EventExtraction xtr;
    private static Object lock = new Object();

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.dbUtilsProvider = (DBUtilsProvider)aContext.getResourceObject(RESOURCE_TRAINED_DB);
            this.trainedDb = this.dbUtilsProvider.getTrainedDatabase();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.loader = new DataLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String docId;
        String text = aJCas.getDocumentText();
        FSIterator headerIt = aJCas.getAnnotationIndex(Header.type).iterator();
        if (headerIt.hasNext()) {
            Header header = (Header)headerIt.next();
            docId = header.getDocId();
        } else {
            docId = "<unknown ID>";
        }
        DBUtils docDb = null;
        try {
            log.debug("Processing document {}", (Object)docId);
            Map<String, Gene> proteins = this.enumerateProteins(aJCas);
            if (proteins.isEmpty()) {
                log.debug("Skipping event extraction for this document because no proteins have been found that could be involved in an event.");
                return;
            }
            List<String> proteinLines = this.getProteinLines(proteins);
            Object object = lock;
            synchronized (object) {
                try {
                    docDb = this.loader.Txt2Db(docId, text, proteinLines);
                }
                catch (NullPointerException e) {
                    log.debug("Could not create text database for document {} due to NullPointerException during creation. Trying to close the DB and open it again after a short delay", (Object)docId);
                    Thread.sleep(10000L);
                    try {
                        docDb = this.loader.Txt2Db(docId + "-secondtry", text, proteinLines);
                    }
                    catch (Exception e2) {
                        log.error("Repeatedly failed to create text database for document " + docId + ". This document will be skipped. Exception was: ", (Throwable)e2);
                        throw e2;
                    }
                }
            }
            if (null == this.xtr) {
                this.xtr = new EventExtraction(this.trainedDb, docDb);
            } else {
                this.xtr.setDb(docDb);
            }
            this.xtr.Test();
            Set triggers = this.xtr.getExtractedTriggers();
            Set events = this.xtr.getExtractedEvents();
            log.debug("Got {} triggers from BioSem.", (Object)triggers.size());
            log.debug("Got {} events from BioSem.", (Object)events.size());
            this.addEventsToIndexes(events, proteins, triggers, aJCas);
        }
        catch (BioSemException e) {
            log.debug("BioSemException occurred: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error occurred in document " + docId + ":", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        finally {
            block41: {
                try {
                    if (docDb == null) break block41;
                    Object e = lock;
                    synchronized (e) {
                        docDb.closeDB();
                    }
                }
                catch (Exception e) {
                    log.warn("Exception while shutting down document database for document {}. Since events have already been extracted, this is a minor error taken for itself. However it could lead to subsequent errors in the HSQL database system which could be critical.", (Object)docId);
                }
            }
        }
    }

    private void addEventsToIndexes(Set<PData> events, Map<String, Gene> proteinMap, Set<Word> triggers, JCas aJCas) {
        HashMap<String, Word> triggerMap = new HashMap<String, Word>();
        HashMap<String, PData> eventMap = new HashMap<String, PData>();
        HashMap<String, EventMention> eventAnnotations = new HashMap<String, EventMention>();
        HashMap<String, EventTrigger> triggerAnnotations = new HashMap<String, EventTrigger>();
        for (Word trg : triggers) {
            triggerMap.put(trg.TID, trg);
        }
        for (PData event : events) {
            eventMap.put(event.PID, event);
        }
        for (PData event : events) {
            try {
                this.addEventToIndexes(event, proteinMap, triggerMap, eventAnnotations, triggerAnnotations, aJCas);
            }
            catch (UnknownProteinIdException e) {
                String docId = "<unknown>";
                FSIterator it = aJCas.getAnnotationIndex(Header.type).iterator();
                if (it.hasNext()) {
                    Header h = (Header)it.next();
                    docId = h.getDocId();
                }
                log.error("Exception occured in document " + docId + ". The respective event will be skipped. Error was: ", (Throwable)e);
            }
        }
    }

    private EventMention addEventToIndexes(PData event, Map<String, Gene> proteinMap, Map<String, Word> triggerMap, HashMap<String, EventMention> eventAnnotations, HashMap<String, EventTrigger> triggerAnnotations, JCas aJCas) throws UnknownProteinIdException {
        EventMention uimaEvent;
        EventTrigger uimaTrigger = triggerAnnotations.get(event.trig_ID);
        if (null == uimaTrigger) {
            Word trg = triggerMap.get(event.getTrigger().TID);
            if (null == trg) {
                throw new IllegalStateException("BioSem event \"" + event + "\" refers to trigger with ID " + event.trig_ID + " which could not be found.");
            }
            uimaTrigger = this.addTriggerToIndexes(trg, aJCas);
        }
        if (null == (uimaEvent = eventAnnotations.get(event.PID))) {
            int begin = uimaTrigger.getBegin();
            int end = uimaTrigger.getEnd();
            Word protArg1 = event.getPro1();
            Word protArg2 = event.getPro2();
            PData eventArg1 = event.getPdata1();
            PData eventArg2 = event.getPdata2();
            uimaEvent = new EventMention(aJCas, begin, end);
            uimaEvent.setId(event.PID);
            uimaEvent.setSpecificType(uimaTrigger.getSpecificType());
            uimaEvent.setTrigger(uimaTrigger);
            if (null != protArg2) {
                this.addUimaEventArgument(uimaEvent, protArg2, 2, proteinMap, triggerMap, eventAnnotations, triggerAnnotations, aJCas);
            }
            if (null != eventArg2) {
                this.addUimaEventArgument(uimaEvent, eventArg2, 2, proteinMap, triggerMap, eventAnnotations, triggerAnnotations, aJCas);
            }
            if (null != protArg1) {
                this.addUimaEventArgument(uimaEvent, protArg1, 1, proteinMap, triggerMap, eventAnnotations, triggerAnnotations, aJCas);
            }
            if (null != eventArg1) {
                this.addUimaEventArgument(uimaEvent, eventArg1, 1, proteinMap, triggerMap, eventAnnotations, triggerAnnotations, aJCas);
            }
            uimaEvent.addToIndexes();
            eventAnnotations.put(event.PID, uimaEvent);
        }
        return uimaEvent;
    }

    private void addUimaEventArgument(EventMention uimaEvent, Object bioSemArg, int argPos, Map<String, Gene> proteinMap, Map<String, Word> triggerMap, HashMap<String, EventMention> eventAnnotations, HashMap<String, EventTrigger> triggerAnnotations, JCas aJCas) throws UnknownProteinIdException {
        if (null == bioSemArg) {
            throw new IllegalArgumentException("An argument that should be added to the event " + uimaEvent + " at position " + argPos + " was null.");
        }
        ArgumentMention uimaArg = null;
        if (bioSemArg instanceof Word) {
            Word wordArg = (Word)bioSemArg;
            Gene protein = proteinMap.get(wordArg.TID);
            if (null == protein) {
                throw new UnknownProteinIdException("BioSem returned a protein event argument with ID " + wordArg.TID + " which is no valid gene/protein annotation ID in this CAS. Protein keys: " + proteinMap.keySet() + ". Word: " + wordArg.word + ". This event is skipped. This error should be examined. It hasn't yet due to time reasons...");
            }
            protein.setSpecificType("protein");
            uimaArg = new ArgumentMention(aJCas, protein.getBegin(), protein.getEnd());
            uimaArg.setRef((Annotation)protein);
            uimaArg.setRole(this.determineArgumentRole(uimaEvent, uimaArg, argPos));
        } else if (bioSemArg instanceof PData) {
            PData eventArg = (PData)bioSemArg;
            EventMention uimaEventArg = eventAnnotations.get(eventArg.PID);
            if (null == uimaEventArg) {
                uimaEventArg = this.addEventToIndexes(eventArg, proteinMap, triggerMap, eventAnnotations, triggerAnnotations, aJCas);
            }
            if (null == uimaEventArg) {
                throw new IllegalStateException("Creating UIMA EventMention annotation for BioSem event \"" + eventArg.toString() + "\" failed, the UIMA EventMention is null.");
            }
            uimaArg = new ArgumentMention(aJCas, uimaEventArg.getBegin(), uimaEventArg.getEnd());
            uimaArg.setRef((Annotation)uimaEventArg);
            uimaArg.setRole(this.determineArgumentRole(uimaEvent, uimaArg, argPos));
        } else {
            throw new IllegalArgumentException("Unsupported event argument was passed for the creation of a UIMA ArgumentMention: " + bioSemArg);
        }
        FSArray uimaArgs = uimaEvent.getArguments();
        if (uimaArgs != null && argPos <= uimaArgs.size()) {
            if (uimaArgs.get(argPos - 1) != null) {
                throw new IllegalStateException("The UIMA ArgumentMention " + uimaArg + " should be put on position " + (argPos - 1) + " of UIMA event " + uimaEvent + ". But there is already an argument there: " + uimaArgs.get(argPos - 1));
            }
            uimaArgs.set(argPos - 1, (FeatureStructure)uimaArg);
        } else {
            if (null != uimaArgs) {
                throw new IllegalStateException("The UIMA ArgumentMention " + uimaArg + " should be put on position position " + (argPos - 1) + " of UIMA event " + uimaEvent + ". However, there already exists an argument FSArray but it is too small (size: " + uimaArgs.size() + " to take the new argument. This shouldn't happen by design of the code.");
            }
            uimaArgs = new FSArray(aJCas, argPos);
            uimaArgs.set(argPos - 1, (FeatureStructure)uimaArg);
        }
        uimaEvent.setArguments(uimaArgs);
    }

    private String determineArgumentRole(EventMention uimaEvent, ArgumentMention uimaArg, int argPos) {
        if (argPos == 1) {
            return "Theme";
        }
        if (uimaEvent.getSpecificType().equals("Binding") && !(uimaArg.getRef() instanceof EventMention)) {
            return "Theme2";
        }
        return "Cause";
    }

    private EventTrigger addTriggerToIndexes(Word trg, JCas aJCas) {
        String id = trg.TID;
        int begin = trg.locs[0];
        int end = trg.locs[1];
        String type = trg.type;
        EventTrigger uimaTrigger = new EventTrigger(aJCas, begin, end);
        uimaTrigger.setId(id);
        uimaTrigger.setSpecificType(type);
        return uimaTrigger;
    }

    private List<String> getProteinLines(Map<String, Gene> proteins) {
        ArrayList<String> proteinLines = new ArrayList<String>();
        for (Map.Entry<String, Gene> proteinEntry : proteins.entrySet()) {
            String id = proteinEntry.getKey();
            Gene gene = proteinEntry.getValue();
            try {
                proteinLines.add(id + "\tProtein\t" + gene.getBegin() + "\t" + gene.getEnd() + "\t" + gene.getCoveredText());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Failed to process Protein with its values.");
            }
        }
        return proteinLines;
    }

    private Map<String, Gene> enumerateProteins(JCas aJCas) {
        int i = 0;
        HashMap<String, Gene> proteins = new HashMap<String, Gene>();
        FSIterator geneIt = aJCas.getAnnotationIndex(Gene.type).iterator();
        int lastEnd = 0;
        while (geneIt.hasNext()) {
            Gene gene = (Gene)geneIt.next();
            if (gene.getBegin() < lastEnd) continue;
            String id = gene.getId();
            id = "T" + i++;
            gene.setId(id);
            proteins.put(id, gene);
            lastEnd = gene.getEnd();
        }
        log.debug("Got {} non-overlapping genes/proteins in the document.", (Object)proteins.size());
        return proteins;
    }

    public void destroy() {
        super.destroy();
        this.dbUtilsProvider.closeDatabase();
    }
}

