/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.bionlpformat.utils;

import com.google.common.collect.Lists;
import de.julielab.jcore.reader.bionlpformat.utils.AnnotationFileMapper;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.medical.Dose;
import de.julielab.jcore.types.medical.Duration;
import de.julielab.jcore.types.medical.Frequency;
import de.julielab.jcore.types.medical.Medication;
import de.julielab.jcore.types.medical.Modus;
import de.julielab.jcore.types.medical.Reason;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationFileMapper_Med {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationFileMapper.class);
    private static final String MEDICATION = "Medication";
    private static final String ANAPHORA = "Anaphora";
    private static final String DOSE = "Dose";
    private static final String FREQUENCY = "Frequency";
    private static final String DURATION = "Duration";
    private static final String MODUS = "Modus";
    private static final String REASON = "Reason";
    private static final Set<String> ENTITIES = new HashSet<String>(Arrays.asList("Medication", "Anaphora"));
    private static final Set<String> EVENTS = new HashSet<String>(Arrays.asList("Dose", "Frequency", "Duration", "Modus", "Reason"));

    public void mapEventFile(BufferedReader bufferedReader, JCas jcas) throws IOException {
        HashMap<String, Annotation> mappedAnnotations = new HashMap<String, Annotation>();
        this.mapFile(mappedAnnotations, bufferedReader, jcas);
    }

    private void mapFile(Map<String, Annotation> mappedAnnotations, BufferedReader bufferedReader, JCas jcas) throws IOException {
        HashMap<String, String> eventEntries = new HashMap<String, String>();
        ArrayList<String> corefEntries = new ArrayList<String>();
        ArrayList<ArrayList> equivalents = new ArrayList<ArrayList>();
        ArrayList<String> attrEntries = new ArrayList<String>();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("T")) {
                this.mapEntity(mappedAnnotations, line, jcas);
                continue;
            }
            if (line.startsWith("E")) {
                eventEntries.put(line.substring(0, line.indexOf("\t")), line);
                continue;
            }
            if (line.startsWith("R")) {
                corefEntries.add(line);
                continue;
            }
            if (line.startsWith("A")) {
                attrEntries.add(line);
                continue;
            }
            if (!line.startsWith("*\tEquiv")) continue;
            String equivIDs = line.substring(line.indexOf("Equiv") + 5).trim();
            equivalents.add(Lists.newArrayList((Object[])equivIDs.split(" ")));
        }
        for (String eventID : eventEntries.keySet()) {
            if (mappedAnnotations.keySet().contains(eventID)) continue;
            this.mapEventEntry(mappedAnnotations, eventEntries, eventID, jcas);
        }
    }

    private void mapEntity(Map<String, Annotation> mappedEntities, String entry, JCas jcas) {
        String[] headAndTail = entry.split("\t");
        String id = headAndTail[0];
        String tail = headAndTail[1];
        String[] tokens = tail.split(" ");
        Medication annotation = null;
        Boolean isEntity = false;
        Boolean isEvent = false;
        if (ENTITIES.contains(tokens[0])) {
            isEntity = true;
            if (tokens[0].equals(MEDICATION)) {
                Medication medication;
                annotation = medication = new Medication(jcas);
            } else if (tokens[0].equals(ANAPHORA)) {
                // empty if block
            }
        } else if (EVENTS.contains(tokens[0])) {
            isEvent = true;
            if (tokens[0].equals(DOSE)) {
                Dose dose = new Dose(jcas);
                annotation = dose;
            } else if (tokens[0].equals(DURATION)) {
                Duration duration = new Duration(jcas);
                annotation = duration;
            } else if (tokens[0].equals(FREQUENCY)) {
                Frequency frequency = new Frequency(jcas);
                annotation = frequency;
            } else if (tokens[0].equals(MODUS)) {
                Modus modus = new Modus(jcas);
                annotation = modus;
            } else if (tokens[0].equals(REASON)) {
                Reason reason = new Reason(jcas);
                annotation = reason;
            }
        }
        annotation.setId(id);
        annotation.setBegin(new Integer(tokens[1]).intValue());
        annotation.setEnd(new Integer(tokens[tokens.length - 1]).intValue());
        annotation.addToIndexes();
        mappedEntities.put(id, (Annotation)annotation);
    }

    private void mapEventEntry(Map<String, Annotation> mappedAnnotations, Map<String, String> eventEntries, String eventID, JCas cas) {
        String[] headAndTail = eventEntries.get(eventID).split("\t");
        String id = headAndTail[0];
        String tail = headAndTail[1];
        String[] tokens = tail.split("\\p{Blank}+");
        String triggerID = tokens[0].split(":")[1];
        String triggerName = tokens[0].split(":")[0];
        EventMention event = (EventMention)mappedAnnotations.get(triggerID);
        FSArray arguments = new FSArray(cas, tokens.length - 1);
        for (int i = 1; i < tokens.length; ++i) {
            String[] argumentStrings = tokens[i].split(":");
            String argumentID = argumentStrings[1];
            Annotation argumentAnnotation = mappedAnnotations.get(argumentID);
            if (argumentAnnotation == null) {
                this.mapEventEntry(mappedAnnotations, eventEntries, argumentID, cas);
                argumentAnnotation = mappedAnnotations.get(argumentID);
            }
            ArgumentMention argument = new ArgumentMention(cas);
            argument.setRef(argumentAnnotation);
            argument.setBegin(argumentAnnotation.getBegin());
            argument.setEnd(argumentAnnotation.getEnd());
            String role = argumentStrings[0];
            argument.setRole(role);
            arguments.set(i - 1, (FeatureStructure)argument);
        }
        event.setArguments(arguments);
        event.setSpecificType(triggerName);
        event.addToIndexes();
        mappedAnnotations.put(id, (Annotation)event);
    }
}

