/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.bionlpformat.utils;

import com.google.common.collect.Lists;
import de.julielab.jcore.reader.bionlpformat.main.FormatClashException;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.CorefExpression;
import de.julielab.jcore.types.CorefRelation;
import de.julielab.jcore.types.Entity;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.EventTrigger;
import de.julielab.jcore.types.Gene;
import de.julielab.jcore.utility.JCoReTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationFileMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationFileMapper.class);
    private static final String PROTEIN = "Protein";
    private static final String PROTEIN_SPECIFIC_TYPE = "protein";
    private static final String ENTITY_MENTION_SPECIFIC_TYPE = "entity";
    private static final String COREF_EXPRESSION = "Exp";
    private static final String ENTITY = "Entity";
    private static final String THEME = "Theme";
    private static final String THEME2 = "Theme2";
    private static final String CAUSE = "Cause";
    private int numCorefRelations = 0;
    private int numCorefExpressions = 0;

    public void mapEventFile(Map<String, Annotation> mappedProteins, BufferedReader bufferedReader, JCas cas) throws IOException {
        HashMap<String, Annotation> mappedAnnotations = new HashMap<String, Annotation>();
        if (mappedProteins != null) {
            mappedAnnotations.putAll(mappedProteins);
        }
        this.mapFile(mappedAnnotations, bufferedReader, cas);
    }

    public Map<String, Annotation> mapProteinFile(BufferedReader bufferedReader, JCas cas) throws IOException {
        HashMap<String, Annotation> mappedProteins = new HashMap<String, Annotation>();
        this.mapFile(mappedProteins, bufferedReader, cas);
        return mappedProteins;
    }

    private void mapFile(Map<String, Annotation> mappedAnnotations, BufferedReader bufferedReader, JCas cas) throws IOException {
        HashMap<String, String> eventEntries = new HashMap<String, String>();
        ArrayList<String> corefEntries = new ArrayList<String>();
        ArrayList<ArrayList> equivalents = new ArrayList<ArrayList>();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("T")) {
                this.mapEntity(mappedAnnotations, line, cas);
                continue;
            }
            if (line.startsWith("E")) {
                eventEntries.put(line.substring(0, line.indexOf("\t")), line);
                continue;
            }
            if (line.startsWith("*\tEquiv")) {
                String equivIDs = line.substring(line.indexOf("Equiv") + 5).trim();
                equivalents.add(Lists.newArrayList((Object[])equivIDs.split(" ")));
                continue;
            }
            if (!line.startsWith("R")) continue;
            corefEntries.add(line);
        }
        for (String string : eventEntries.keySet()) {
            if (mappedAnnotations.keySet().contains(string)) continue;
            this.mapEventEntry(mappedAnnotations, eventEntries, string, cas);
        }
        for (Collection collection : equivalents) {
            this.mapEquivalents(mappedAnnotations, collection, cas);
        }
        for (String string : corefEntries) {
            this.mapCorefRelation(mappedAnnotations, string, cas);
        }
        LOGGER.trace("Number of coreference expressions: {}", (Object)this.getNumCorefExpressions());
        LOGGER.trace("Number of coreference relations: {}", (Object)this.getNumCorefRelations());
    }

    private void mapCorefRelation(Map<String, Annotation> mappedAnnotations, String corefEntry, JCas cas) {
        block7: {
            String corefId = corefEntry.split("\\t", 2)[0];
            Pattern relationPattern = Pattern.compile("Coref(?:erence)? (?:Anaphora|Subject):(T[0-9]+)( (?:Antecedent|Object)[0-9]*:T[0-9]+)+");
            Matcher relationMatcher = relationPattern.matcher(corefEntry);
            Matcher idMatcher = Pattern.compile("T[0-9]+").matcher("");
            try {
                if (relationMatcher.find()) {
                    String relationString = relationMatcher.group();
                    CorefExpression anaphora = null;
                    idMatcher.reset(relationString);
                    if (!idMatcher.find()) {
                        throw new FormatClashException(relationString);
                    }
                    String anaphoraId = idMatcher.group();
                    anaphora = this.createCorefExpression(anaphora, mappedAnnotations.get(anaphoraId), cas, false);
                    ArrayList<CorefExpression> antecedents = new ArrayList<CorefExpression>();
                    while (idMatcher.find()) {
                        String antecedentId = idMatcher.group();
                        CorefExpression antecedent = null;
                        CorefExpression antecedentExpression = this.createCorefExpression(antecedent, mappedAnnotations.get(antecedentId), cas, true);
                        antecedents.add(antecedentExpression);
                    }
                    FSArray antecedentArray = new FSArray(cas, antecedents.size());
                    for (int i = 0; i < antecedents.size(); ++i) {
                        CorefExpression antecedent = (CorefExpression)antecedents.get(i);
                        antecedentArray.set(i, (FeatureStructure)antecedent);
                    }
                    CorefRelation corefRel = new CorefRelation(cas);
                    ++this.numCorefRelations;
                    corefRel.setId(corefId);
                    corefRel.setAntecedents(antecedentArray);
                    corefRel.setAnaphora(anaphora);
                    anaphora.setAntecedentRelation(corefRel);
                    for (int i = 0; i < antecedents.size(); ++i) {
                        CorefExpression antecedent = (CorefExpression)antecedents.get(i);
                        antecedent.setAnaphoraRelations(JCoReTools.addToFSArray((FSArray)antecedent.getAnaphoraRelations(), (FeatureStructure)corefRel));
                    }
                    break block7;
                }
                throw new FormatClashException(corefEntry);
            }
            catch (FormatClashException e) {
                LOGGER.error("Expression {} could not be parsed correctly as coreference relation, check the format and correct the error.", (Object)e.getMessage());
                throw new IllegalStateException("Line " + corefEntry + " could not be parsed correctly as coreference relation, check the format and correct the error.");
            }
        }
    }

    private CorefExpression createCorefExpression(CorefExpression coref, Annotation trigger, JCas cas, boolean isAntecedent) {
        coref = new CorefExpression(cas);
        coref.setBegin(trigger.getBegin());
        coref.setEnd(trigger.getEnd());
        coref.setId(trigger.getId());
        if (!isAntecedent) {
            coref.setIsAnaphor(true);
        } else {
            coref.setIsAntecedent(true);
        }
        coref.addToIndexes();
        return coref;
    }

    private void mapEquivalents(Map<String, Annotation> mappedAnnotations, Collection<String> equiv, JCas cas) {
        Entity entity = new Entity(cas);
        entity.setBegin(0);
        entity.setEnd(0);
        FSArray mentions = new FSArray(cas, equiv.size());
        int i = 0;
        for (String id : equiv) {
            EntityMention entityMention = (EntityMention)mappedAnnotations.get(id);
            entityMention.setRef((TOP)entity);
            mentions.set(i++, (FeatureStructure)entityMention);
        }
        entity.setMentions(mentions);
        entity.addToIndexes(cas);
    }

    private void mapEventEntry(Map<String, Annotation> mappedAnnotations, Map<String, String> eventEntries, String eventID, JCas cas) {
        String[] headAndTail = eventEntries.get(eventID).split("\t");
        String id = headAndTail[0];
        String tail = headAndTail[1];
        String[] tokens = tail.split("\\p{Blank}+");
        String triggerID = tokens[0].split(":")[1];
        EventTrigger trigger = (EventTrigger)mappedAnnotations.get(triggerID);
        EventMention event = new EventMention(cas);
        event.setId(id);
        event.setBegin(trigger.getBegin());
        event.setEnd(trigger.getEnd());
        event.setSpecificType(trigger.getSpecificType());
        LOGGER.trace(trigger.getSpecificType());
        FSArray arguments = new FSArray(cas, tokens.length - 1);
        for (int i = 1; i < tokens.length; ++i) {
            LOGGER.trace(tokens[i]);
            String[] argumentStrings = tokens[i].split(":");
            String argumentID = argumentStrings[1];
            Annotation argumentAnnotation = mappedAnnotations.get(argumentID);
            if (argumentAnnotation == null) {
                this.mapEventEntry(mappedAnnotations, eventEntries, argumentID, cas);
                argumentAnnotation = mappedAnnotations.get(argumentID);
            }
            ArgumentMention argument = new ArgumentMention(cas);
            argument.setRef(argumentAnnotation);
            argument.setBegin(argumentAnnotation.getBegin());
            argument.setEnd(argumentAnnotation.getEnd());
            String role = argumentStrings[0];
            role = this.changeRole(role);
            argument.setRole(role);
            arguments.set(i - 1, (FeatureStructure)argument);
        }
        event.setTrigger(trigger);
        event.setArguments(arguments);
        event.addToIndexes();
        mappedAnnotations.put(id, (Annotation)event);
    }

    private String changeRole(String role) {
        if (role.equals(THEME2)) {
            role = new String(THEME);
        }
        return role;
    }

    private void mapEntity(Map<String, Annotation> mappedEntities, String entry, JCas cas) {
        String[] headAndTail = entry.split("\t");
        String id = headAndTail[0];
        String tail = headAndTail[1];
        String[] tokens = tail.split(" ");
        Gene annotation = null;
        if (tokens[0].equals(PROTEIN)) {
            Gene protein = new Gene(cas);
            protein.setSpecificType(PROTEIN_SPECIFIC_TYPE);
            annotation = protein;
        } else if (tokens[0].equals(ENTITY)) {
            EntityMention entityMention = new EntityMention(cas);
            entityMention.setSpecificType(ENTITY_MENTION_SPECIFIC_TYPE);
            annotation = entityMention;
        } else if (tokens[0].equals(COREF_EXPRESSION)) {
            annotation = new CorefExpression(cas);
            ++this.numCorefExpressions;
        } else {
            EventTrigger eventTrigger = new EventTrigger(cas);
            eventTrigger.setSpecificType(tokens[0]);
            annotation = eventTrigger;
        }
        annotation.setId(id);
        annotation.setBegin(new Integer(tokens[1]).intValue());
        annotation.setEnd(new Integer(tokens[tokens.length - 1]).intValue());
        annotation.addToIndexes();
        mappedEntities.put(id, (Annotation)annotation);
    }

    public int getNumCorefRelations() {
        return this.numCorefRelations;
    }

    public int getNumCorefExpressions() {
        return this.numCorefExpressions;
    }
}

