/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.bionlpformat.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OntoFormatReader {
    final String sectionRegEx = "\\s*\\[\\s*(\\w+)\\s*\\]\\s*";
    final String commentRegEx = "\\s*#\\s*.*";
    final Pattern sectionPattern = Pattern.compile("\\s*\\[\\s*(\\w+)\\s*\\]\\s*");
    final Pattern commentPattern = Pattern.compile("\\s*#\\s*.*", 32);
    BufferedReader ontoReader;

    public void readFile(File ontoFile) throws IOException {
        this.ontoReader = new BufferedReader(new FileReader(ontoFile));
        String section = "";
        String line = null;
        while ((line = this.ontoReader.readLine()) != null) {
            if (this.commentPattern.matcher(line).matches() || line.trim().isEmpty()) continue;
            Matcher sectionMatcher = this.sectionPattern.matcher(line);
            if (sectionMatcher.matches()) {
                section = sectionMatcher.group(1);
                continue;
            }
            if (section.equals("entities")) {
                System.out.println(line);
                continue;
            }
            if (section != "relations" && section != "events" && section != "attributes") continue;
        }
    }
}

