/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.bionlpformat.main;

import de.julielab.jcore.reader.bionlpformat.main.BioEventReader;
import de.julielab.jcore.reader.bionlpformat.utils.AnnotationFileMapper_Med;
import de.julielab.jcore.reader.bionlpformat.utils.TextFileMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedEventReader
extends CollectionReader_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioEventReader.class);
    public static final String DIRECTORY_PARAM = "inDirectory";
    public static final String ANNOTATION_FILE_PARAM = "annotationFile";
    public static final String TEXT_FILE_PARAM = "textFile";
    private File[] files;
    private int i;
    private AnnotationFileMapper_Med annotationFileMapper;
    private TextFileMapper textFileMapper;
    @ConfigurationParameter(name="inDirectory", mandatory=true)
    private String directoryName;
    @ConfigurationParameter(name="annotationFile", mandatory=false)
    private String annotationFileString;
    @ConfigurationParameter(name="textFile", mandatory=false)
    private String textFileString;
    private File directory;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return name.endsWith(".txt");
            }
        };
        this.directoryName = (String)this.getConfigParameterValue(DIRECTORY_PARAM);
        this.directory = new File(this.directoryName);
        this.files = this.directory.listFiles(filter);
        this.textFileMapper = new TextFileMapper();
        this.annotationFileMapper = new AnnotationFileMapper_Med();
        this.i = -1;
    }

    public void getNext(CAS cas) throws IOException, CollectionException {
        File textFile = null;
        try {
            textFile = this.files[this.i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.error("File access crashed for \"" + ((Object)((Object)this)).getClass().getName() + "\": call \"hasNext()\" first!");
            e.printStackTrace();
        }
        String textFilename = textFile.getName();
        String fid = textFilename.substring(0, textFilename.indexOf("."));
        File annotationFile = new File(this.directory, fid + ".ann");
        JCas jcas = null;
        try {
            jcas = cas.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        LOGGER.debug("Reading " + fid);
        BufferedReader textReader = new BufferedReader(new FileReader(textFile));
        this.textFileMapper.mapAbstractFile(fid, textFilename, textReader, jcas);
        BufferedReader annotationReader = new BufferedReader(new FileReader(annotationFile));
        this.annotationFileMapper.mapEventFile(annotationReader, jcas);
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.i, this.files.length, this.files[this.i].getName().substring(0, this.files[this.i].getName().indexOf(".")))};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return ++this.i < this.files.length;
    }
}

