/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.bionlpformat.main;

import de.julielab.jcore.reader.bionlpformat.utils.AnnotationFileMapper;
import de.julielab.jcore.reader.bionlpformat.utils.TextFileMapper;
import de.julielab.jcore.types.Annotation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioEventReader
extends CollectionReader_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioEventReader.class);
    public static final String DIRECTORY_PARAM = "inDirectory";
    public static final String PROTEIN_FILE_PARAM = "proteinFile";
    public static final String ABSTRACT_FILE_PARAM = "abstractFile";
    public static final String BIOEVENT_SERVICE_MODE_PARAM = "bioEventServiceMode";
    private File[] files;
    private int i;
    private AnnotationFileMapper annotationFileMapper;
    private TextFileMapper abstractFileMapper;
    @ConfigurationParameter(name="inDirectory", mandatory=true)
    private String directoryName;
    @ConfigurationParameter(name="proteinFile", mandatory=false)
    private String proteinFileString;
    @ConfigurationParameter(name="abstractFile", mandatory=false)
    private String abstractFileString;
    @ConfigurationParameter(name="bioEventServiceMode", mandatory=false)
    private boolean bioEventServiceMode;
    private File directory;
    File proteinFile;
    File abstractFile;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                return name.endsWith(".txt");
            }
        };
        if ((Boolean)this.getConfigParameterValue(BIOEVENT_SERVICE_MODE_PARAM) != null) {
            this.bioEventServiceMode = (Boolean)this.getConfigParameterValue(BIOEVENT_SERVICE_MODE_PARAM);
        }
        if (!this.bioEventServiceMode) {
            this.directoryName = (String)this.getConfigParameterValue(DIRECTORY_PARAM);
            this.directory = new File(this.directoryName);
            this.files = this.directory.listFiles(filter);
        }
        this.abstractFileMapper = new TextFileMapper();
        this.annotationFileMapper = new AnnotationFileMapper();
        this.i = -1;
        if (this.bioEventServiceMode) {
            this.proteinFileString = (String)this.getConfigParameterValue(PROTEIN_FILE_PARAM);
            this.abstractFileString = (String)this.getConfigParameterValue(ABSTRACT_FILE_PARAM);
            if (this.abstractFileString != null) {
                this.abstractFile = new File(this.abstractFileString);
            }
            if (this.abstractFile != null && this.abstractFile.exists()) {
                this.files = new File[1];
                this.files[0] = new File(this.abstractFileString);
            } else {
                LOGGER.error("[initialize] abstract file does not exist");
            }
            if (this.proteinFileString != null) {
                this.proteinFile = new File(this.proteinFileString);
            }
            if (this.proteinFile == null || !this.proteinFile.exists()) {
                LOGGER.error("[initialize] protein file does not exist");
            }
        }
    }

    public void getNext(CAS cas) throws IOException, CollectionException {
        if (!this.bioEventServiceMode) {
            File abstractFile = null;
            try {
                abstractFile = this.files[this.i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("File access crashed for \"" + ((Object)((Object)this)).getClass().getName() + "\": call \"hasNext()\" first!");
                e.printStackTrace();
            }
            String abstractFilename = abstractFile.getName();
            String pid = abstractFilename.substring(0, abstractFilename.indexOf("."));
            File proteinFile = new File(this.directory, pid + ".a1");
            File eventFile = new File(this.directory, pid + ".a2");
            JCas jcas = null;
            try {
                jcas = cas.getJCas();
            }
            catch (CASException e) {
                throw new CollectionException((Throwable)e);
            }
            LOGGER.debug("Reading " + pid);
            BufferedReader abstractReader = new BufferedReader(new FileReader(abstractFile));
            this.abstractFileMapper.mapAbstractFile(pid, abstractFilename, abstractReader, jcas);
            BufferedReader proteinReader = new BufferedReader(new FileReader(proteinFile));
            Map<String, Annotation> mappedProteins = this.annotationFileMapper.mapProteinFile(proteinReader, jcas);
            BufferedReader eventReader = null;
            if (eventFile.exists()) {
                eventReader = new BufferedReader(new FileReader(eventFile));
                this.annotationFileMapper.mapEventFile(mappedProteins, eventReader, jcas);
            }
        } else {
            File abstractFile = this.files[this.i];
            String abstractFilename = abstractFile.getName();
            String pid = abstractFilename.substring(0, abstractFilename.indexOf("."));
            File proteinFile = new File(this.proteinFileString);
            JCas jcas = null;
            try {
                jcas = cas.getJCas();
            }
            catch (CASException e) {
                throw new CollectionException((Throwable)e);
            }
            LOGGER.debug("Reading " + pid);
            BufferedReader abstractReader = new BufferedReader(new FileReader(abstractFile));
            this.abstractFileMapper.mapAbstractFile(pid, abstractFilename, abstractReader, jcas);
            BufferedReader proteinReader = new BufferedReader(new FileReader(proteinFile));
            Map<String, Annotation> map = this.annotationFileMapper.mapProteinFile(proteinReader, jcas);
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.i, this.files.length, "docs")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return ++this.i < this.files.length;
    }
}

