/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.utils;

import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.medical.Medication;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.jcas.cas.FSArray;

public class EventMentionWriter {
    private Writer writer;
    private String documentText;
    private Set<String> writtenIds;
    private int eventId = 1;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public EventMentionWriter(Writer writer, String documentText) {
        this.writer = writer;
        this.documentText = documentText;
        this.writtenIds = new HashSet<String>();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void writeEvent(Medication med) {
        EventMention em;
        int i;
        FSArray dosArray = med.getDose();
        FSArray durArray = med.getDuration();
        FSArray freqArray = med.getFrequency();
        FSArray modArray = med.getModus();
        FSArray reasArray = med.getReason();
        if (dosArray != null) {
            for (i = 0; i < dosArray.size(); ++i) {
                em = (EventMention)dosArray.get(i);
                this.writeTrigger(em);
                this.writeEvent(med, em);
            }
        }
        if (durArray != null) {
            for (i = 0; i < durArray.size(); ++i) {
                em = (EventMention)durArray.get(i);
                this.writeTrigger(em);
                this.writeEvent(med, em);
            }
        }
        if (freqArray != null) {
            for (i = 0; i < freqArray.size(); ++i) {
                em = (EventMention)freqArray.get(i);
                this.writeTrigger(em);
                this.writeEvent(med, em);
            }
        }
        if (modArray != null) {
            for (i = 0; i < modArray.size(); ++i) {
                em = (EventMention)modArray.get(i);
                this.writeTrigger(em);
                this.writeEvent(med, em);
            }
        }
        if (reasArray != null) {
            for (i = 0; i < reasArray.size(); ++i) {
                em = (EventMention)reasArray.get(i);
                this.writeTrigger(em);
                this.writeEvent(med, em);
            }
        }
    }

    private void writeEvent(Medication med, EventMention em) {
        String line = "E" + Integer.toString(this.eventId++) + "\t" + em.getSpecificType() + ":" + em.getId() + " " + em.getSpecificType() + "-Arg:" + med.getId() + "\n";
        try {
            this.writer.write(line);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeTrigger(EventMention em) {
        String line = em.getId() + "\t" + em.getSpecificType() + " " + em.getBegin() + " " + em.getEnd() + "\t" + this.documentText.substring(em.getBegin(), em.getEnd()) + "\n";
        try {
            this.writer.write(line);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isWritten(EventMention event) {
        return this.writtenIds.contains(event.getId());
    }
}

