/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.utils;

import de.julielab.jcore.types.EntityMention;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class EntityWriter {
    private Writer writer;
    private String documentText;
    private Set<String> writtenIds;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public EntityWriter(Writer writer, String documentText) {
        this.writer = writer;
        this.documentText = documentText;
        this.writtenIds = new HashSet<String>();
    }

    public void writeEntity(EntityMention entity) throws IOException {
        String id = entity.getId();
        String etype = "Entity";
        this.writtenIds.add(id);
        if (entity.getSpecificType() != null) {
            etype = entity.getSpecificType().equals("DRUG") ? "Medication" : "Entity";
        }
        Object line = "";
        line = entity.getId() + "\t" + etype + " " + entity.getBegin() + " " + entity.getEnd() + "\t" + this.documentText.substring(entity.getBegin(), entity.getEnd()) + "\n";
        this.writer.write((String)line);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean isWritten(EntityMention entity) {
        return this.writtenIds.contains(entity.getId());
    }
}

