/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.utils;

import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

public class SegmentWriter {
    private Writer writer;
    private Integer tcount;
    private String documentText;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public SegmentWriter(Writer annotationFileWriter, String docText) {
        this.writer = annotationFileWriter;
        this.tcount = 1;
        this.documentText = docText;
    }

    public void writeSentence(Sentence sentence) {
        CAS cas = sentence.getCAS();
        Type tokenType = cas.getTypeSystem().getType(Token.class.getCanonicalName());
        FSIterator tokenIter = cas.getAnnotationIndex(tokenType).subiterator((AnnotationFS)sentence);
        this.writeLine((Annotation)sentence, "Sentence");
        this.writeTokens((FSIterator<AnnotationFS>)tokenIter);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void writeLine(Annotation ann, String atype) {
        String begin_end;
        int tcount;
        String ltrimmed;
        String t;
        Integer n = this.tcount;
        Integer n2 = this.tcount = Integer.valueOf(this.tcount + 1);
        Object out_line = "T" + n + "\t" + atype + " ";
        Integer begin = 0;
        Boolean first = true;
        Pattern p = Pattern.compile(System.lineSeparator(), 258);
        Matcher m = p.matcher(ann.getCoveredText());
        Object text = "";
        while (m.find()) {
            if (!first.booleanValue() && m.start() == begin.intValue()) {
                begin = begin + 1;
                continue;
            }
            t = ann.getCoveredText().substring(begin, m.start());
            ltrimmed = t.replaceAll("^\\s+", "");
            tcount = t.indexOf(ltrimmed);
            text = (String)text + ltrimmed + " ";
            begin_end = Integer.toString(ann.getBegin() + begin + tcount) + " " + Integer.toString(ann.getBegin() + m.start()) + ";";
            out_line = (String)out_line + begin_end;
            begin = m.end();
            first = false;
        }
        if (begin < ann.getCoveredText().length()) {
            t = ann.getCoveredText().substring(begin, ann.getCoveredText().length());
            ltrimmed = t.replaceAll("^\\s+", "");
            tcount = t.indexOf(ltrimmed);
            text = (String)text + ltrimmed;
            begin_end = Integer.toString(ann.getBegin() + begin + tcount) + " " + Integer.toString(ann.getBegin() + ann.getCoveredText().length());
            out_line = (String)out_line + begin_end;
        } else {
            text = ((String)text).substring(0, ((String)text).length() - 1 >= 0 ? ((String)text).length() - 1 : 0);
            out_line = ((String)out_line).substring(0, ((String)out_line).length() - 1);
        }
        out_line = (String)out_line + "\t" + (String)text + "\n";
        try {
            this.writer.write((String)out_line);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeTokens(FSIterator<AnnotationFS> tokenIter) {
        while (tokenIter.hasNext()) {
            Token token = (Token)tokenIter.next();
            this.writeLine((Annotation)token, "Token");
        }
    }

    public void writeTokensOnly(CAS cas) {
        Type tokenType = cas.getTypeSystem().getType(Token.class.getCanonicalName());
        FSIterator tokenIter = cas.getAnnotationIndex(tokenType).iterator();
        this.writeTokens((FSIterator<AnnotationFS>)tokenIter);
    }
}

