/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.utils;

import de.julielab.jcore.types.Gene;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class ProteinWriter {
    private Writer writer;
    private String documentText;
    private Set<String> writtenIds;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public ProteinWriter(Writer writer, String documentText) {
        this.writer = writer;
        this.documentText = documentText;
        this.writtenIds = new HashSet<String>();
    }

    public void writeProtein(Gene protein) throws IOException {
        String id = protein.getId();
        if (!this.writtenIds.contains(id)) {
            this.writtenIds.add(id);
        }
        String line = protein.getId() + "\tProtein " + protein.getBegin() + " " + protein.getEnd() + "\t" + this.documentText.substring(protein.getBegin(), protein.getEnd()) + "\n";
        this.writer.write(line);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean isWritten(Gene protein) {
        return this.writtenIds.contains(protein.getId());
    }
}

