/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.utils;

import de.julielab.jcore.consumer.bionlpformat.utils.EntityWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.EventTriggerWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.ProteinWriter;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.EventTrigger;
import de.julielab.jcore.types.Gene;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.jcas.cas.FSArray;

public class BioEventWriter {
    private Writer writer;
    private ProteinWriter proteinWriter;
    private EventTriggerWriter triggerWriter;
    private EntityWriter entityWriter;
    private Set<String> writtenIds;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public BioEventWriter(Writer writer, ProteinWriter proteinWriter, EventTriggerWriter triggerWriter, EntityWriter entityWriter) {
        this.writer = writer;
        this.proteinWriter = proteinWriter;
        this.triggerWriter = triggerWriter;
        this.entityWriter = entityWriter;
        this.writtenIds = new HashSet<String>();
    }

    public void writeEvent(EventMention event) throws IOException {
        if (null == event) {
            throw new IllegalArgumentException("null reference has been passed instead on an EventMention instance.");
        }
        String id = event.getId();
        if (this.writtenIds.contains(id)) {
            System.out.println("ERROR! Event already written " + event.getId() + " " + event.getCoveredText());
            return;
        }
        this.writtenIds.add(id);
        EventTrigger trigger = event.getTrigger();
        if (null == trigger) {
            throw new IllegalArgumentException("An EventMention without a trigger occurred: " + event);
        }
        if (!this.triggerWriter.isWritten(trigger)) {
            this.triggerWriter.writeTrigger(trigger);
        }
        String line = event.getId() + "\t" + trigger.getSpecificType() + ":" + trigger.getId() + " ";
        FSArray arguments = event.getArguments();
        if (null == arguments || 0 == arguments.size()) {
            throw new IllegalArgumentException("An EventMention without arguments occurred: " + event);
        }
        for (int i = 0; i < arguments.size(); ++i) {
            EntityMention entityMention;
            ArgumentMention argument = (ArgumentMention)arguments.get(i);
            if (argument == null) continue;
            Annotation reference = argument.getRef();
            if (null == reference) {
                throw new IllegalArgumentException("An argument with a null-entitiy-reference occurred: " + argument + "; EventMention: " + event);
            }
            line = line + argument.getRole() + ":" + reference.getId();
            if (i < arguments.size() - 1) {
                line = line + " ";
            }
            if (this.proteinWriter == null || this.entityWriter == null) continue;
            if (reference instanceof Gene) {
                Gene protein = (Gene)reference;
                if (this.proteinWriter.isWritten(protein) || !protein.getSpecificType().equals("protein")) continue;
                this.proteinWriter.writeProtein(protein);
                continue;
            }
            if (!(reference instanceof EntityMention) || this.entityWriter.isWritten(entityMention = (EntityMention)reference)) continue;
            this.entityWriter.writeEntity((EntityMention)reference);
        }
        line = line + "\n";
        this.writer.write(line);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.proteinWriter != null) {
            this.proteinWriter.close();
        }
        if (this.triggerWriter != null) {
            this.triggerWriter.close();
        }
        if (this.entityWriter != null) {
            this.entityWriter.close();
        }
    }
}

