/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlpformat.main;

import de.julielab.jcore.consumer.bionlpformat.utils.BioEventWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.DocumentWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.EntityWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.EventTriggerWriter;
import de.julielab.jcore.consumer.bionlpformat.utils.ProteinWriter;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.pubmed.Header;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioEventConsumer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioEventConsumer.class);
    public static final String DIRECTORY_PARAM = "outDirectory";
    public static final String A2_FILE_PARAM = "a2FileString";
    public static final String BIOEVENT_SERVICE_MODE_PARAM = "bioEventServiceMode";
    @ConfigurationParameter(name="outDirectory", mandatory=true)
    private File directory;
    @ConfigurationParameter(name="bioEventServiceMode", mandatory=false)
    private boolean bioEventServiceMode;
    @ConfigurationParameter(name="a2FileString", mandatory=false)
    private String a2FileString;
    File a2File;
    int id = 1;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if ((Boolean)aContext.getConfigParameterValue(BIOEVENT_SERVICE_MODE_PARAM) != null) {
            this.bioEventServiceMode = (Boolean)aContext.getConfigParameterValue(BIOEVENT_SERVICE_MODE_PARAM);
        }
        if (!this.bioEventServiceMode) {
            String directoryName = (String)aContext.getConfigParameterValue(DIRECTORY_PARAM);
            this.directory = new File(directoryName);
            if (!this.directory.exists()) {
                this.directory.mkdir();
            }
        } else {
            this.a2FileString = (String)aContext.getConfigParameterValue(A2_FILE_PARAM);
            if (this.a2FileString != null) {
                this.a2File = new File(this.a2FileString);
            } else {
                LOGGER.error("[initialize] a2 file path is null. Exit program");
                System.exit(-1);
            }
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        CAS cas = aJCas.getCas();
        String id = this.getDocumentId(cas);
        String documentText = cas.getDocumentText();
        Type eventType = cas.getTypeSystem().getType(EventMention.class.getCanonicalName());
        try {
            if (!this.bioEventServiceMode) {
                DocumentWriter documentWriter = this.createDocumentWriter(id);
                BioEventWriter eventWriter = this.createEventWriter(documentText, id);
                documentWriter.write(cas.getJCas());
                FSIterator eventIterator = cas.getAnnotationIndex(eventType).iterator();
                boolean i = true;
                while (eventIterator.hasNext()) {
                    EventMention eventMention = (EventMention)eventIterator.next();
                    eventWriter.writeEvent(eventMention);
                }
                documentWriter.close();
                eventWriter.close();
            } else {
                BioEventWriter eventWriter = this.createEventWriter(documentText, this.a2File);
                FSIterator eventIterator = cas.getAnnotationIndex(eventType).iterator();
                boolean i = true;
                while (eventIterator.hasNext()) {
                    EventMention eventMention = (EventMention)eventIterator.next();
                    eventWriter.writeEvent(eventMention);
                }
                eventWriter.close();
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private BioEventWriter createEventWriter(String documentText, File file) {
        BufferedWriter eventFileWriter = null;
        EventTriggerWriter triggerWriter = null;
        try {
            eventFileWriter = null;
            triggerWriter = null;
            eventFileWriter = new BufferedWriter(new FileWriter(this.a2File));
            triggerWriter = new EventTriggerWriter(eventFileWriter, documentText);
        }
        catch (IOException e) {
            LOGGER.error("[createEventWriter] " + e.getMessage());
            e.printStackTrace();
        }
        return new BioEventWriter(eventFileWriter, null, triggerWriter, null);
    }

    private BioEventWriter createEventWriter(String documentText, String id) throws AnalysisEngineProcessException {
        BufferedWriter proteinFileWriter = null;
        BufferedWriter eventFileWriter = null;
        ProteinWriter proteinWriter = null;
        EventTriggerWriter triggerWriter = null;
        EntityWriter entityWriter = null;
        try {
            proteinFileWriter = new BufferedWriter(new FileWriter(new File(this.directory, id + ".a1")));
            eventFileWriter = new BufferedWriter(new FileWriter(new File(this.directory, id + ".a2")));
            proteinWriter = new ProteinWriter(proteinFileWriter, documentText);
            triggerWriter = new EventTriggerWriter(eventFileWriter, documentText);
            entityWriter = new EntityWriter(eventFileWriter, documentText);
            return new BioEventWriter(eventFileWriter, proteinWriter, triggerWriter, entityWriter);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private DocumentWriter createDocumentWriter(String id) throws IOException {
        return new DocumentWriter(new BufferedWriter(new FileWriter(new File(this.directory, id + ".txt"))));
    }

    private String getDocumentId(CAS cas) {
        Header header = null;
        Type headerType = cas.getTypeSystem().getType(Header.class.getCanonicalName());
        try {
            FSIterator iterator = cas.getJCas().getAnnotationIndex(Header.type).iterator();
            header = (Header)iterator.next();
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        if (header != null) {
            return header.getDocId();
        }
        return new Integer(this.id++).toString();
    }
}

