/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlp09event.utils;

import de.julielab.jcore.consumer.bionlp09event.utils.EntityWriter;
import de.julielab.jcore.consumer.bionlp09event.utils.EventTriggerWriter;
import de.julielab.jcore.consumer.bionlp09event.utils.ProteinWriter;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.ArgumentMention;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.EventMention;
import de.julielab.jcore.types.EventTrigger;
import de.julielab.jcore.types.Gene;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.jcas.cas.FSArray;

public class EventWriter {
    private Writer writer;
    private ProteinWriter proteinWriter;
    private EventTriggerWriter triggerWriter;
    private EntityWriter entityWriter;
    private Set<String> writtenIds;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public EventWriter(Writer writer, ProteinWriter proteinWriter, EventTriggerWriter triggerWriter, EntityWriter entityWriter) {
        this.writer = writer;
        this.proteinWriter = proteinWriter;
        this.triggerWriter = triggerWriter;
        this.entityWriter = entityWriter;
        this.writtenIds = new HashSet<String>();
    }

    public void writeEvent(EventMention event) throws IOException {
        if (event == null) {
            throw new IllegalArgumentException("null reference has been passed instead on an EventMention instance.");
        }
        String id = event.getId();
        if (this.writtenIds.contains(id)) {
            System.out.println("ERROR! Event already written " + event.getId() + " " + event.getCoveredText());
            return;
        }
        this.writtenIds.add(id);
        EventTrigger trigger = event.getTrigger();
        if (trigger == null) {
            throw new IllegalArgumentException("An EventMention without a trigger occurred: " + event);
        }
        if (!this.triggerWriter.isWritten(trigger)) {
            this.triggerWriter.writeTrigger(trigger);
        }
        String line = String.valueOf(event.getId()) + "\t" + trigger.getSpecificType() + ":" + trigger.getId() + " ";
        FSArray arguments = event.getArguments();
        if (arguments == null || arguments.size() == 0) {
            throw new IllegalArgumentException("An EventMention without arguments occurred: " + event);
        }
        int i = 0;
        while (i < arguments.size()) {
            ArgumentMention argument = (ArgumentMention)arguments.get(i);
            if (argument != null) {
                Annotation reference = argument.getRef();
                if (reference == null) {
                    throw new IllegalArgumentException("An argument with a null-entitiy-reference occurred: " + argument + "; EventMention: " + event);
                }
                line = String.valueOf(line) + argument.getRole() + ":" + reference.getId();
                if (i < arguments.size() - 1) {
                    line = String.valueOf(line) + " ";
                }
                if (this.proteinWriter != null && this.entityWriter != null) {
                    EntityMention entityMention;
                    if (reference instanceof Gene) {
                        Gene protein = (Gene)reference;
                        if (!this.proteinWriter.isWritten(protein) && protein.getSpecificType().equals("protein")) {
                            this.proteinWriter.writeProtein(protein);
                        }
                    } else if (reference instanceof EntityMention && !this.entityWriter.isWritten(entityMention = (EntityMention)reference)) {
                        this.entityWriter.writeEntity((EntityMention)reference);
                    }
                }
            }
            ++i;
        }
        line = String.valueOf(line) + "\n";
        this.writer.write(line);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.proteinWriter != null) {
            this.proteinWriter.close();
        }
        if (this.triggerWriter != null) {
            this.triggerWriter.close();
        }
        if (this.entityWriter != null) {
            this.entityWriter.close();
        }
    }
}

