/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.bionlp09event.utils;

import de.julielab.jcore.types.EventTrigger;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class EventTriggerWriter {
    private Writer writer;
    private String documentText;
    private Set<String> writtenIds;

    public Writer getFileWriter() {
        return this.writer;
    }

    public void setFileWriter(Writer writer) {
        this.writer = writer;
    }

    public EventTriggerWriter(Writer writer, String documentText) {
        this.writer = writer;
        this.documentText = documentText;
        this.writtenIds = new HashSet<String>();
    }

    public void writeTrigger(EventTrigger trigger) throws IOException {
        String id = trigger.getId();
        if (!this.writtenIds.contains(id)) {
            this.writtenIds.add(id);
        }
        String line = String.valueOf(trigger.getId()) + "\t" + trigger.getSpecificType() + " " + trigger.getBegin() + " " + trigger.getEnd() + "\t" + this.documentText.substring(trigger.getBegin(), trigger.getEnd()) + "\n";
        this.writer.write(line);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean isWritten(EventTrigger trigger) {
        return this.writtenIds.contains(trigger.getId());
    }
}

