/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.biolemmatizer;

import de.julielab.jcore.types.Lemma;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Token;
import edu.ucdenver.ccp.nlp.biolemmatizer.LemmataEntry;
import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioLemmatizer
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(BioLemmatizer.class);
    public static edu.ucdenver.ccp.nlp.biolemmatizer.BioLemmatizer bioLemm;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        bioLemm = new edu.ucdenver.ccp.nlp.biolemmatizer.BioLemmatizer();
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String tokenString = null;
        String tag = null;
        try {
            AnnotationIndex jcoreTokenIndex = aJCas.getAnnotationIndex(Token.type);
            FSIterator tokenIterator = jcoreTokenIndex.iterator();
            while (tokenIterator.hasNext()) {
                Token token = (Token)tokenIterator.get();
                tokenString = token.getCoveredText();
                LemmataEntry lemmaEntry = null;
                try {
                    if (token.getPosTag() != null) {
                        POSTag posTag = token.getPosTag(0);
                        tag = posTag.getValue();
                        lemmaEntry = bioLemm.lemmatizeByLexiconAndRules(tokenString, tag);
                    } else {
                        lemmaEntry = bioLemm.lemmatizeByLexiconAndRules(tokenString, "");
                    }
                }
                catch (IllegalStateException | IndexOutOfBoundsException e) {
                    log.debug("BioLemmatizer-internal exception: ", (Throwable)e);
                }
                if (lemmaEntry != null) {
                    Collection lemmaCollection = lemmaEntry.getLemmas();
                    LemmataEntry.Lemma lemma = (LemmataEntry.Lemma)lemmaCollection.iterator().next();
                    String lem = lemma.getLemma();
                    Lemma jcoreLemma = new Lemma(aJCas, token.getBegin(), token.getEnd());
                    jcoreLemma.setValue(lem);
                    token.setLemma(jcoreLemma);
                } else {
                    Lemma jcoreLemma = new Lemma(aJCas, token.getBegin(), token.getEnd());
                    jcoreLemma.setValue(tokenString);
                    token.setLemma(jcoreLemma);
                }
                tokenIterator.next();
            }
        }
        catch (Exception e) {
            log.error("Exception occurred:", (Throwable)e);
        }
    }
}

