/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.banner;

import banner.eval.BANNER;
import banner.postprocessing.PostProcessor;
import banner.tagging.CRFTagger;
import banner.tagging.dictionary.DictionaryTagger;
import banner.tokenization.Tokenizer;
import banner.types.EntityType;
import banner.types.Mention;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.jcore.utility.JCoReTools;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import dragon.nlp.tool.lemmatiser.EngLemmatiser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeCapability(inputs={"de.julielab.jcore.types.Sentence"}, outputs={"de.julielab.jcore.types.Gene"})
public class BANNERAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_CONFIG_FILE = "ConfigFile";
    public static final String PARAM_TYPE_MAPPING = "TypeMapping";
    private static final Logger log = LoggerFactory.getLogger(BANNERAnnotator.class);
    private Tokenizer tokenizer;
    private DictionaryTagger dictionary;
    private HierarchicalConfiguration config;
    private EngLemmatiser lemmatiser;
    private Tagger posTagger;
    private CRFTagger tagger;
    private PostProcessor postProcessor;
    @ConfigurationParameter(name="ConfigFile", description="The XML configuration file for BANNER.")
    private String configFilePath;
    @ConfigurationParameter(name="TypeMapping", mandatory=false, description="A list of mappings from entity labels to UIMA types in the form <label>=<fully qualified type name>. If not given, all entities will be realized as EntityMention instances.")
    private String[] typeMappings;
    private Map<String, String> typeMap;
    private InputStream modelIs;
    private String modelFilename;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.configFilePath = (String)aContext.getConfigParameterValue(PARAM_CONFIG_FILE);
            this.typeMappings = (String[])Optional.ofNullable(aContext.getConfigParameterValue(PARAM_TYPE_MAPPING)).orElse(new String[0]);
            File configFile = new File(this.configFilePath);
            if (configFile.exists()) {
                log.debug("Found configuration file {}", (Object)configFile);
                this.config = new XMLConfiguration(configFile);
            } else {
                Object classpathAddress = this.configFilePath.startsWith("/") ? this.configFilePath : "/" + this.configFilePath;
                log.debug("Did not find configuration file as regular file at {}. Trying as classpath resource with address {}", (Object)configFile, classpathAddress);
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream((String)classpathAddress);
                if (is != null) {
                    log.debug("Found configuration file as classpath resource {}. Loading configuration.", classpathAddress);
                    this.config = new XMLConfiguration();
                    ((XMLConfiguration)this.config).load(is);
                } else {
                    throw new ResourceInitializationException("could_not_access_data", new Object[]{this.configFilePath});
                }
            }
            this.typeMap = Stream.of(this.typeMappings).map(m -> m.split("\\s*=\\s*")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
            this.tokenizer = BANNER.getTokenizer(this.config);
            this.dictionary = BANNER.getDictionary(this.config);
            this.lemmatiser = BANNER.getLemmatiser(this.config);
            this.posTagger = BANNER.getPosTagger(this.config);
            this.postProcessor = BANNER.getPostProcessor(this.config);
            SubnodeConfiguration subConfig = this.config.configurationAt("banner.eval");
            this.modelFilename = subConfig.getString("modelFilename");
            this.modelIs = new File(this.modelFilename).exists() ? new FileInputStream(this.modelFilename) : ((Object)((Object)this)).getClass().getResourceAsStream((String)(this.modelFilename.startsWith("/") ? this.modelFilename : "/" + this.modelFilename));
            if (null == this.modelIs) {
                throw new ResourceInitializationException("could_not_access_data", new Object[]{this.modelFilename});
            }
            log.info("{}: {}", (Object)PARAM_CONFIG_FILE, (Object)this.configFilePath);
            log.info("{}: {}", (Object)PARAM_TYPE_MAPPING, (Object)Arrays.toString(this.typeMappings));
            log.info("Model: {}", (Object)this.modelFilename);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this.tagger == null) {
            try {
                this.tagger = CRFTagger.load(this.modelIs, (Lemmatiser)this.lemmatiser, this.posTagger, this.dictionary);
            }
            catch (IOException e) {
                log.error("Could not load the BANNER model at {}", (Object)this.modelFilename, (Object)e);
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
        String docId = "<unknown>";
        try {
            docId = JCoReTools.getDocId((JCas)jcas);
            FSIterator sentIt = jcas.getAnnotationIndex(Sentence.type).iterator();
            int geneCount = 0;
            int sentCount = 0;
            while (sentIt.hasNext()) {
                Sentence jcoreSentence = (Sentence)sentIt.next();
                int sentenceBegin = jcoreSentence.getBegin();
                String sentenceId = jcoreSentence.getId() != null ? jcoreSentence.getId() : docId + ": " + sentCount++;
                banner.types.Sentence sentence = new banner.types.Sentence(sentenceId, docId, jcoreSentence.getCoveredText());
                try {
                    sentence = BANNER.process(this.tagger, this.tokenizer, this.postProcessor, sentence);
                }
                catch (Exception e) {
                    log.error("Exception while running BANNER on sentence {}", (Object)jcoreSentence.getCoveredText(), (Object)e);
                    throw e;
                }
                for (Mention mention : sentence.getMentions()) {
                    EntityType entityType = mention.getEntityType();
                    String typeName = this.typeMap.getOrDefault(entityType.getText(), EntityMention.class.getCanonicalName());
                    Annotation a = JCoReAnnotationTools.getAnnotationByClassName((JCas)jcas, (String)typeName);
                    a.setBegin(sentenceBegin + mention.getStartChar());
                    a.setEnd(sentenceBegin + mention.getEndChar());
                    if (a instanceof de.julielab.jcore.types.Annotation) {
                        de.julielab.jcore.types.Annotation jcoreA = (de.julielab.jcore.types.Annotation)a;
                        jcoreA.setId("BANNER, " + docId + ": " + geneCount++);
                        jcoreA.setComponentId(BANNERAnnotator.class.getCanonicalName());
                        jcoreA.setConfidence(String.valueOf(mention.getProbability()));
                    }
                    if (a instanceof EntityMention) {
                        EntityMention e = (EntityMention)a;
                        e.setSpecificType(entityType.getText());
                    }
                    a.addToIndexes();
                }
            }
        }
        catch (Exception e) {
            log.error("Exception occurred while running the BANNER annotator on document {}.", (Object)docId, (Object)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

