/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

public abstract class SetSimilarityMetric
extends Enum<SetSimilarityMetric> {
    public static final /* enum */ SetSimilarityMetric Dice = new SetSimilarityMetric(){

        @Override
        protected double similarityInternal(int intersection, int size1, int size2) {
            return 2.0 * (double)intersection / (double)(size1 + size2);
        }
    };
    public static final /* enum */ SetSimilarityMetric BooleanXJaccard = new SetSimilarityMetric(){

        @Override
        protected double similarityInternal(int intersection, int size1, int size2) {
            if (size1 > intersection) {
                return 0.0;
            }
            return (double)intersection / (double)(size1 + size2 - intersection);
        }
    };
    public static final /* enum */ SetSimilarityMetric Jaccard = new SetSimilarityMetric(){

        @Override
        protected double similarityInternal(int intersection, int size1, int size2) {
            return (double)intersection / (double)(size1 + size2 - intersection);
        }
    };
    public static final /* enum */ SetSimilarityMetric Overlap = new SetSimilarityMetric(){

        @Override
        protected double similarityInternal(int intersection, int size1, int size2) {
            return (double)intersection / (double)Math.min(size1, size2);
        }
    };
    public static final /* enum */ SetSimilarityMetric CosineTheta = new SetSimilarityMetric(){

        @Override
        protected double similarityInternal(int intersection, int size1, int size2) {
            return (double)(intersection * intersection) / (double)(size1 * size2);
        }
    };
    private static final /* synthetic */ SetSimilarityMetric[] $VALUES;

    public static SetSimilarityMetric[] values() {
        return (SetSimilarityMetric[])$VALUES.clone();
    }

    public static SetSimilarityMetric valueOf(String name) {
        return Enum.valueOf(SetSimilarityMetric.class, name);
    }

    public double similarity(int intersection, int size1, int size2) {
        if (intersection > Math.min(size1, size2)) {
            throw new IllegalArgumentException("Illegal arguments - intersection:" + intersection + ", size1:" + size1 + ", size2:" + size2);
        }
        double similarity = this.similarityInternal(intersection, size1, size2);
        assert (similarity > 0.0);
        if (similarity > 1.0 && similarity < 1.000001) {
            similarity = 1.0;
        }
        assert (similarity <= 1.0);
        return similarity;
    }

    protected abstract double similarityInternal(int var1, int var2, int var3);

    static {
        $VALUES = new SetSimilarityMetric[]{Dice, BooleanXJaccard, Jaccard, Overlap, CosineTheta};
    }
}

