/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

public class RankedList<E> {
    private double[] values;
    private E[] objects;
    private int sizeVal = 0;

    public RankedList(int maxSize) {
        this.values = new double[maxSize];
        this.objects = new Object[maxSize];
    }

    public void add(double value, E obj) {
        int index;
        if (Double.isNaN(value)) {
            return;
        }
        for (index = this.sizeVal; index > 0 && value > this.values[index - 1]; --index) {
            if (index >= this.objects.length) continue;
            this.values[index] = this.values[index - 1];
            this.objects[index] = this.objects[index - 1];
        }
        if (index < this.objects.length) {
            this.values[index] = value;
            this.objects[index] = obj;
            if (this.sizeVal < this.objects.length) {
                ++this.sizeVal;
            }
        }
    }

    public int find(E obj) {
        for (int i = 0; i < this.sizeVal; ++i) {
            if (!this.objects[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.sizeVal = 0;
    }

    public E getObject(int rank) {
        if (rank >= this.sizeVal) {
            throw new IndexOutOfBoundsException();
        }
        return this.objects[rank];
    }

    public double getValue(int rank) {
        if (rank >= this.sizeVal) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[rank];
    }

    public int maxSize() {
        return this.objects.length;
    }

    public int size() {
        return this.sizeVal;
    }
}

