/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

import banner.util.Index;
import banner.util.RankedList;
import banner.util.SetSimilarityMetric;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndexedMetricSetSimilarity<E, V> {
    private SetSimilarityMetric metric;
    private int resultsSize;
    private Index<E, Integer> elementToIndex;
    private List<V> indexToValue;
    private TIntArrayList indexToSize;

    public IndexedMetricSetSimilarity(SetSimilarityMetric metric, int resultsSize) {
        this.metric = metric;
        this.resultsSize = resultsSize;
        this.elementToIndex = new Index();
        this.indexToValue = new ArrayList<V>();
        this.indexToSize = new TIntArrayList();
    }

    public void addValue(Collection<E> elements, V value) {
        assert (this.indexToValue.size() == this.indexToSize.size());
        Integer index = new Integer(this.indexToValue.size());
        this.indexToValue.add(value);
        int size = 0;
        for (E element : elements) {
            E transform = this.transform(element);
            if (transform == null) continue;
            this.elementToIndex.add(transform, index);
            ++size;
        }
        this.indexToSize.add(size);
    }

    public RankedList<V> indexMatch(Collection<E> lookupElements) {
        int[] counts = new int[this.indexToValue.size()];
        HashSet<E> transformedLookupElementSet = new HashSet<E>();
        for (E element : lookupElements) {
            E transform = this.transform(element);
            if (transform == null) continue;
            transformedLookupElementSet.add(transform);
        }
        for (E element : transformedLookupElementSet) {
            Set<Integer> indexSet = this.elementToIndex.lookup(element);
            if (indexSet == null) continue;
            for (Integer index : indexSet) {
                int n = index;
                counts[n] = counts[n] + 1;
            }
        }
        int lookupSize = transformedLookupElementSet.size();
        RankedList<V> results = new RankedList<V>(this.resultsSize);
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] <= 0) continue;
            V value = this.indexToValue.get(i);
            int size = this.indexToSize.get(i);
            double similarity = this.metric.similarity(counts[i], lookupSize, size);
            if (!(similarity > 0.0)) continue;
            results.add(similarity, value);
        }
        return results;
    }

    protected E transform(E element) {
        return element;
    }
}

