/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntityType {
    private static final Map<String, EntityType> types = new HashMap<String, EntityType>();
    private String text;
    private EntityType parent;

    private EntityType(String text, EntityType parent) {
        this.text = text;
        this.parent = parent;
    }

    public static EntityType getType(String text) {
        return EntityType.getType(text, null);
    }

    public static EntityType getType(String text, EntityType parent) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        EntityType type = types.get(text);
        if (type == null) {
            type = new EntityType(text, parent);
            types.put(text, type);
        }
        return type;
    }

    public static Map<EntityType, EntityType> getViewMap(EntityType type) {
        HashSet<EntityType> ancestors = new HashSet<EntityType>();
        EntityType current = type;
        while (current != null) {
            ancestors.add(current);
            current = current.parent;
        }
        HashMap<EntityType, EntityType> viewMap = new HashMap<EntityType, EntityType>();
        Iterator<EntityType> iterator = new HashSet<EntityType>(types.values()).iterator();
        while (iterator.hasNext()) {
            EntityType temp;
            current = temp = iterator.next();
            while (current != null && !ancestors.contains(current)) {
                current = current.parent;
            }
            viewMap.put(temp, current);
        }
        return Collections.unmodifiableMap(viewMap);
    }

    public static Set<EntityType> getTypes() {
        return Collections.unmodifiableSet(new HashSet<EntityType>(types.values()));
    }

    public String getText() {
        return this.text;
    }

    public EntityType getParent() {
        return this.parent;
    }

    public List<EntityType> getAncestors() {
        ArrayList<EntityType> ancestors = new ArrayList<EntityType>();
        EntityType type = this;
        while (type != null) {
            ancestors.add(type);
            type = type.parent;
        }
        return Collections.unmodifiableList(ancestors);
    }

    public String toString() {
        if (this.parent == null) {
            return this.text;
        }
        return this.parent.toString() + "->" + this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityType other = (EntityType)obj;
        return this.text.equals(other.text);
    }
}

