/*
 * Decompiled with CFR 0.152.
 */
package banner.types;

import banner.types.Entity;
import banner.types.EntityName;
import banner.types.Mention;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EntityIdentification {
    private Mention mention;
    private Map<EntityName, Double> nameValue;

    public EntityIdentification(Mention mention) {
        this.mention = mention;
        this.nameValue = new HashMap<EntityName, Double>();
    }

    public Double set(EntityName name, double value) {
        return this.nameValue.put(name, value);
    }

    public Mention getMention() {
        return this.mention;
    }

    public Set<EntityName> getNames() {
        TreeSet<EntityName> sortedNames = new TreeSet<EntityName>(new Comparator<EntityName>(){

            @Override
            public int compare(EntityName name1, EntityName name2) {
                if (name1.equals(name2)) {
                    return 0;
                }
                Double value1 = EntityIdentification.this.nameValue.get(name1);
                Double value2 = EntityIdentification.this.nameValue.get(name2);
                int comparison = value2.compareTo(value1);
                if (comparison != 0) {
                    return comparison;
                }
                comparison = name1.getName().compareTo(name2.getName());
                if (comparison != 0) {
                    return comparison;
                }
                return name1.hashCode() - name2.hashCode();
            }
        });
        sortedNames.addAll(this.nameValue.keySet());
        return Collections.unmodifiableSet(sortedNames);
    }

    public Double getValue(EntityName name) {
        return this.nameValue.get(name);
    }

    public Double getBestValue() {
        Double bestValue = null;
        for (EntityName name : this.nameValue.keySet()) {
            Double value = this.nameValue.get(name);
            if (bestValue != null && !(bestValue < value)) continue;
            bestValue = value;
        }
        return bestValue;
    }

    public Set<Entity> getBestEntities() {
        Double bestValue = this.getBestValue();
        HashSet<Entity> bestEntities = new HashSet<Entity>();
        for (EntityName name : this.nameValue.keySet()) {
            if (!bestValue.equals(this.nameValue.get(name))) continue;
            bestEntities.add(name.getEntity());
        }
        return bestEntities;
    }

    public EntityIdentification copy(Mention mention2) {
        EntityIdentification identification2 = new EntityIdentification(mention2);
        for (EntityName name : this.nameValue.keySet()) {
            identification2.nameValue.put(name, this.nameValue.get(name));
        }
        return identification2;
    }
}

