/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Pattern;

public class TokenWordClass
extends Pipe {
    private static final long serialVersionUID = 8996255757211528445L;
    String prefix;
    Pattern matchingRegex;
    boolean brief;

    public TokenWordClass(String prefix, Pattern matchingRegex, boolean brief) {
        this.prefix = prefix;
        this.matchingRegex = matchingRegex;
        this.brief = brief;
    }

    public TokenWordClass(String prefix, boolean brief) {
        this.prefix = prefix;
        this.matchingRegex = null;
        this.brief = brief;
    }

    private TokenWordClass() {
    }

    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String text = t.getText();
            if (this.brief) {
                text = text.replaceAll("[A-Z]+", "A");
                text = text.replaceAll("[a-z]+", "a");
                text = text.replaceAll("[0-9]+", "0");
                text = text.replaceAll("[^A-Za-z0-9]+", "x");
            } else {
                text = text.replaceAll("[A-Z]", "A");
                text = text.replaceAll("[a-z]", "a");
                text = text.replaceAll("[0-9]", "0");
                text = text.replaceAll("[^A-Za-z0-9]", "x");
            }
            if (this.matchingRegex != null && !this.matchingRegex.matcher(text).matches()) continue;
            Object featureName = null;
            featureName = this.prefix == null ? text : this.prefix + text;
            t.setFeatureValue((String)featureName, 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
        out.writeObject(this.matchingRegex);
        out.writeBoolean(this.brief);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
        this.matchingRegex = (Pattern)in.readObject();
        this.brief = in.readBoolean();
    }
}

