/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Pattern;

public class LowerCaseTokenText
extends Pipe {
    private static final long serialVersionUID = -2682195735816037070L;
    private String prefix;
    private Pattern matchingRegex;

    public LowerCaseTokenText(String prefix, Pattern matchingRegex) {
        this.prefix = prefix;
        this.matchingRegex = matchingRegex;
    }

    public LowerCaseTokenText(String prefix) {
        this.prefix = prefix;
        this.matchingRegex = null;
    }

    private LowerCaseTokenText() {
    }

    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String text = t.getText().toLowerCase();
            if (this.matchingRegex != null && !this.matchingRegex.matcher(text).matches()) continue;
            Object featureName = null;
            featureName = this.prefix == null ? text : this.prefix + text;
            t.setFeatureValue((String)featureName, 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
        out.writeObject(this.matchingRegex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
        this.matchingRegex = (Pattern)in.readObject();
    }
}

