/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import banner.types.Sentence;
import banner.types.Token;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.TokenSequence;
import dragon.nlp.Word;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LemmaPOS
extends Pipe {
    private static final long serialVersionUID = 1L;
    private boolean expectLemmatiser;
    private boolean expectPOSTagger;
    private transient Map<Thread, Resources> resourcesByThread;

    public LemmaPOS(Lemmatiser lemmatiser, Tagger posTagger) {
        this.initResourcesMap();
        this.getResources().lemmatiser = lemmatiser;
        this.expectLemmatiser = lemmatiser != null;
        this.getResources().posTagger = posTagger;
        this.expectPOSTagger = posTagger != null;
    }

    public void setLemmatiser(Lemmatiser lemmatiser) {
        this.initResourcesMap();
        this.getResources().lemmatiser = lemmatiser;
    }

    public void setPosTagger(Tagger posTagger) {
        this.initResourcesMap();
        this.getResources().posTagger = posTagger;
    }

    private void initResourcesMap() {
        if (this.resourcesByThread == null) {
            this.resourcesByThread = new HashMap<Thread, Resources>();
        }
    }

    private Resources getResources() {
        return this.resourcesByThread.compute(Thread.currentThread(), (t, r) -> {
            Resources ret = r;
            if (ret == null) {
                ret = new Resources();
            }
            return ret;
        });
    }

    public Instance pipe(Instance carrier) {
        int i;
        if (this.expectLemmatiser != (this.getResources().lemmatiser != null)) {
            throw new IllegalStateException("Model was trained with lemmatiser; not present in current config");
        }
        if (this.expectPOSTagger != (this.getResources().posTagger != null)) {
            throw new IllegalStateException("Model was trained with POS tagger; not present in current config");
        }
        Sentence sentence = (Sentence)carrier.getSource();
        List<Token> tokens = sentence.getTokens();
        dragon.nlp.Sentence posSentence = null;
        if (this.getResources().posTagger != null) {
            int size = tokens.size();
            posSentence = new dragon.nlp.Sentence();
            for (i = 0; i < size; ++i) {
                posSentence.addWord(new Word(tokens.get(i).getText()));
            }
            this.getResources().posTagger.tag(posSentence);
        }
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (i = 0; i < ts.size(); ++i) {
            Token bannerToken = tokens.get(i);
            String text = bannerToken.getText();
            cc.mallet.types.Token token = (cc.mallet.types.Token)ts.get(i);
            if (posSentence != null) {
                String featureName = "POS=" + posSentence.getWord(i).getPOSIndex();
                token.setFeatureValue(featureName, 1.0);
            }
            if (this.getResources().lemmatiser == null) continue;
            String lemma = posSentence == null ? this.getResources().lemmatiser.lemmatize(text) : this.getResources().lemmatiser.lemmatize(text, posSentence.getWord(i).getPOSIndex());
            String featureName = "LEMMA=" + lemma;
            token.setFeatureValue(featureName, 1.0);
            token.setProperty("LEMMA", (Object)lemma);
        }
        return carrier;
    }

    private class Resources {
        public Lemmatiser lemmatiser;
        public Tagger posTagger;

        private Resources() {
        }
    }
}

