/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.dictionary;

import banner.tagging.dictionary.DictionaryTagger;
import banner.types.EntityType;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class UMLSMetathesaurusDictionaryTagger
extends DictionaryTagger {
    @Override
    public void load(HierarchicalConfiguration config) throws IOException {
        SubnodeConfiguration localConfig = config.configurationAt(this.getClass().getName());
        String semanticTypesFilename = localConfig.getString("semanticTypesFile");
        HashMap<String, EntityType> typeMap = null;
        int maxIndex = localConfig.getMaxIndex("types");
        if (maxIndex >= 0) {
            typeMap = new HashMap<String, EntityType>();
        }
        for (int i = 0; i <= maxIndex; ++i) {
            HashSet typeNames = new HashSet(localConfig.getList("types(" + i + ").name"));
            String mappedTypeName = localConfig.getString("types(" + i + ").mapTo");
            EntityType mappedType = null;
            if (mappedTypeName != null) {
                mappedType = EntityType.getType(mappedTypeName);
                for (String typeName : typeNames) {
                    typeMap.put(typeName, mappedType);
                }
                continue;
            }
            for (String typeName : typeNames) {
                typeMap.put(typeName, EntityType.getType(typeName));
            }
        }
        HashSet<String> allowedLang = null;
        if (localConfig.containsKey("allowedLang")) {
            allowedLang = new HashSet<String>(localConfig.getList("allowedLang"));
        }
        HashSet<String> allowedPref = null;
        if (localConfig.containsKey("allowedPref")) {
            allowedPref = new HashSet<String>(localConfig.getList("allowedPref"));
        }
        HashSet<String> allowedSupp = null;
        if (localConfig.containsKey("allowedSupp")) {
            allowedSupp = new HashSet<String>(localConfig.getList("allowedSupp"));
        }
        Map<String, Set<EntityType>> cuiToTypeMap = this.loadTypes(semanticTypesFilename, typeMap);
        String conceptNamesFilename = localConfig.getString("conceptNamesFile");
        this.loadConcepts(conceptNamesFilename, cuiToTypeMap, allowedLang, allowedPref, allowedSupp);
    }

    private Map<String, Set<EntityType>> loadTypes(String semanticTypesFilename, Map<String, EntityType> typeMap) throws IOException {
        HashMap<String, Set<EntityType>> cuiToTypeMap = new HashMap<String, Set<EntityType>>();
        BufferedReader reader = new BufferedReader(new FileReader(semanticTypesFilename));
        String line = reader.readLine();
        int lineNum = 0;
        LineFieldParser parser = new LineFieldParser();
        while (line != null) {
            parser.init(line);
            String CUI = parser.getField(0);
            String semanticType = parser.getField(3);
            if (typeMap == null || typeMap.containsKey(semanticType)) {
                HashSet<EntityType> types = (HashSet<EntityType>)cuiToTypeMap.get(CUI);
                if (types == null) {
                    types = new HashSet<EntityType>(1);
                    cuiToTypeMap.put(CUI, types);
                }
                EntityType type = null;
                type = typeMap == null ? EntityType.getType(semanticType) : typeMap.get(semanticType);
                types.add(type);
            }
            line = reader.readLine();
            if (++lineNum % 100000 != 0) continue;
            System.out.println("loadTypes() Line: " + lineNum + " Entries: " + cuiToTypeMap.size() + " types: " + EntityType.getTypes().size());
        }
        return cuiToTypeMap;
    }

    private void loadConcepts(String conceptNamesFilename, Map<String, Set<EntityType>> cuiToTypeMap, Set<String> allowedLang, Set<String> allowedPref, Set<String> allowedSupp) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(conceptNamesFilename));
        String line = reader.readLine();
        int lineNum = 0;
        LineFieldParser parser = new LineFieldParser();
        while (line != null) {
            parser.init(line);
            Set<EntityType> types = cuiToTypeMap.get(parser.getField(0));
            boolean add = types != null;
            add &= allowedLang == null || allowedLang.contains(parser.getField(1));
            add &= allowedPref == null || allowedPref.contains(parser.getField(6));
            String name = parser.getField(14);
            if (add &= allowedSupp == null || allowedSupp.contains(parser.getField(16))) {
                this.add(name, types);
            }
            line = reader.readLine();
            if (++lineNum % 100000 != 0) continue;
            System.out.println("loadConcepts() Line: " + lineNum + " Entries: " + this.size() + " types: " + EntityType.getTypes().size());
        }
    }

    private static class LineFieldParser {
        private String line;
        private int currentField;
        private int beginIndex;
        private int endIndex;

        public void init(String line) {
            this.line = line;
            this.currentField = 0;
            this.beginIndex = 0;
            this.endIndex = line.indexOf("|", this.beginIndex);
        }

        public String getField(int field) {
            if (field < this.currentField) {
                throw new IllegalStateException("Cannot request a field lower than current field");
            }
            while (this.currentField < field) {
                this.advance();
            }
            return this.line.substring(this.beginIndex, this.endIndex);
        }

        private void advance() {
            this.beginIndex = this.endIndex + 1;
            this.endIndex = this.line.indexOf("|", this.beginIndex);
            if (this.endIndex == -1) {
                this.endIndex = this.line.length();
            }
            ++this.currentField;
        }
    }
}

