/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.dictionary;

import banner.tagging.Tagger;
import banner.tokenization.Tokenizer;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Sentence;
import banner.types.Token;
import banner.util.Trie;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class DictionaryTagger
implements Tagger {
    private Tokenizer tokenizer;
    private boolean filterContainedMentions;
    protected Trie<String, Set<EntityType>> entities = new Trie();
    protected Trie<String, Boolean> notInclude = new Trie();
    private boolean normalizeMixedCase;
    private boolean normalizeDigits;
    private boolean generate2PartVariations;
    private boolean dropEndParentheticals;

    public void configure(HierarchicalConfiguration config, Tokenizer tokenizer) {
        SubnodeConfiguration localConfig = config.configurationAt(this.getClass().getName());
        this.filterContainedMentions = localConfig.getBoolean("filterContainedMentions", false);
        this.normalizeMixedCase = localConfig.getBoolean("normalizeMixedCase", false);
        this.normalizeDigits = localConfig.getBoolean("normalizeDigits", false);
        this.generate2PartVariations = localConfig.getBoolean("generate2PartVariations", false);
        this.dropEndParentheticals = localConfig.getBoolean("dropEndParentheticals", false);
        this.tokenizer = tokenizer;
    }

    public void load(HierarchicalConfiguration config) throws IOException {
        SubnodeConfiguration localConfig = config.configurationAt(this.getClass().getName());
        String dictionaryFilename = localConfig.getString("dictionaryFile");
        if (dictionaryFilename == null) {
            throw new IllegalArgumentException("Must specify dictionary filename");
        }
        String dictionaryTypeName = localConfig.getString("dictionaryType");
        if (dictionaryTypeName == null) {
            throw new IllegalArgumentException("Must specify dictionary type");
        }
        String delimiter = localConfig.getString("delimiter");
        int column = localConfig.getInt("column", -1);
        if (delimiter != null && column == -1) {
            throw new IllegalArgumentException("Must specify column if delimiter specified");
        }
        EntityType dictionaryType = EntityType.getType(dictionaryTypeName);
        InputStream resourceAsStream = this.getClass().getResourceAsStream(dictionaryFilename);
        if (null == resourceAsStream) {
            throw new IllegalArgumentException("Could not find dictionary at " + dictionaryFilename);
        }
        try (Scanner scanner = new Scanner(resourceAsStream);){
            Scanner s = scanner.useDelimiter("\\A");
            while (s.hasNext()) {
                String line = s.nextLine();
                if ((line = line.trim()).length() <= 0) continue;
                if (delimiter == null) {
                    this.add(line, dictionaryType);
                    continue;
                }
                String[] split = line.split(delimiter);
                this.add(split[column], dictionaryType);
            }
        }
    }

    protected List<String> process(String input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        List<String> tokens = this.tokenizer.getTokens(input);
        for (int i = 0; i < tokens.size(); ++i) {
            tokens.set(i, this.transform(tokens.get(i)));
        }
        return tokens;
    }

    protected String transform(String str) {
        String result = str;
        if (this.normalizeMixedCase || this.normalizeDigits) {
            char[] chars = str.toCharArray();
            if (this.normalizeMixedCase) {
                int i;
                boolean hasUpper = false;
                boolean hasLower = false;
                for (i = 0; !(i >= chars.length || hasUpper && hasLower); hasUpper |= Character.isUpperCase(chars[i]), hasLower |= Character.isLowerCase(chars[i]), ++i) {
                }
                if (hasUpper && hasLower) {
                    for (i = 0; i < chars.length; ++i) {
                        chars[i] = Character.toLowerCase(chars[i]);
                    }
                }
            }
            if (this.normalizeDigits) {
                for (int i = 0; i < chars.length; ++i) {
                    if (!Character.isDigit(chars[i])) continue;
                    chars[i] = 48;
                }
            }
            result = new String(chars);
        }
        return result;
    }

    public void add(String text, EntityType type) {
        this.add(text, Collections.singleton(type));
    }

    public void add(String text, Collection<EntityType> types) {
        List<String> tokens = this.process(text);
        this.add(tokens, types);
        if (this.generate2PartVariations) {
            if (tokens.size() == 1 && tokens.get(0).matches("[A-Za-z]+[0-9]+")) {
                int split = 0;
                String token = tokens.get(0);
                while (Character.isLetter(token.charAt(split))) {
                    ++split;
                }
                this.add2Part(token.substring(0, split), token.substring(split, token.length()), types);
            }
            if (tokens.size() == 2) {
                this.add2Part(tokens.get(0), tokens.get(1), types);
            }
            if (tokens.size() == 3 && (tokens.get(1).equals("-") || tokens.get(1).equals("/"))) {
                this.add2Part(tokens.get(0), tokens.get(2), types);
            }
        }
    }

    private void add2Part(String part1, String part2, Collection<EntityType> types) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(part1 + part2);
        tokens.add(part2);
        this.add(tokens, types);
        tokens = new ArrayList();
        tokens.add(part1);
        tokens.add(part2);
        this.add(tokens, types);
        tokens.add(1, "-");
        this.add(tokens, types);
        tokens.set(1, "/");
        this.add(tokens, types);
    }

    public boolean add(List<String> tokens, Collection<EntityType> types) {
        Set<EntityType> currentTypes;
        if (tokens.size() == 0) {
            throw new IllegalArgumentException("Number of tokens must be greater than zero");
        }
        Boolean value = this.notInclude.getValue(tokens);
        if (value != null) {
            return false;
        }
        if (this.dropEndParentheticals && tokens.get(tokens.size() - 1).equals(")")) {
            int openParen;
            for (openParen = tokens.size() - 1; openParen > 0 && !tokens.get(openParen).equals("("); --openParen) {
            }
            if (openParen <= 0) {
                return false;
            }
            tokens = tokens.subList(0, openParen);
        }
        if ((currentTypes = this.entities.getValue(tokens)) == null) {
            currentTypes = new HashSet<EntityType>(1);
            this.entities.add(tokens, currentTypes);
        }
        return currentTypes.addAll(types);
    }

    @Override
    public void tag(Sentence sentence) {
        List<Token> tokens = sentence.getTokens();
        LinkedList<Mention> mentions = new LinkedList<Mention>();
        for (int startIndex = 0; startIndex < tokens.size(); ++startIndex) {
            Token currentToken;
            Trie<String, Set<EntityType>> t = this.entities;
            for (int currentIndex = startIndex; currentIndex < tokens.size() && t != null; t = t.getChild(this.transform(currentToken.getText())), ++currentIndex) {
                Set<EntityType> entityTypes = t.getValue();
                if (entityTypes != null) {
                    for (EntityType entityType : entityTypes) {
                        mentions.add(new Mention(sentence, startIndex, currentIndex, entityType, Mention.MentionType.Found));
                    }
                }
                currentToken = tokens.get(currentIndex);
            }
        }
        if (this.filterContainedMentions) {
            while (!mentions.isEmpty()) {
                Mention mention1 = (Mention)mentions.remove(0);
                int start = mention1.getStart();
                int end = mention1.getEnd();
                ArrayList<Mention> adjacentMentions = new ArrayList<Mention>();
                Iterator mentionIterator = mentions.iterator();
                boolean changed = true;
                while (changed) {
                    changed = false;
                    while (mentionIterator.hasNext()) {
                        boolean adjacent;
                        Mention mention2 = (Mention)mentionIterator.next();
                        boolean bl = adjacent = end >= mention2.getStart() && start <= mention2.getEnd();
                        if (!mention1.getEntityType().equals(mention2.getEntityType()) || !adjacent) continue;
                        adjacentMentions.add(mention2);
                        mentionIterator.remove();
                        start = Math.min(start, mention2.getStart());
                        end = Math.max(end, mention2.getEnd());
                        changed = true;
                    }
                }
                sentence.addMention(new Mention(sentence, start, end, mention1.getEntityType(), Mention.MentionType.Found));
            }
        } else {
            for (Mention mention : mentions) {
                sentence.addMention(mention);
            }
        }
    }

    public void suppress(String text) {
        this.notInclude.add(this.process(text), Boolean.TRUE);
    }

    public int size() {
        return this.entities.size();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public boolean isFilterContainedMentions() {
        return this.filterContainedMentions;
    }

    public void setFilterContainedMentions(boolean filterContainedMentions) {
        this.filterContainedMentions = filterContainedMentions;
    }

    public boolean isNormalizeMixedCase() {
        return this.normalizeMixedCase;
    }

    public void setNormalizeMixedCase(boolean normalizeMixedCase) {
        this.normalizeMixedCase = normalizeMixedCase;
    }

    public boolean isNormalizeDigits() {
        return this.normalizeDigits;
    }

    public void setNormalizeDigits(boolean normalizeDigits) {
        this.normalizeDigits = normalizeDigits;
    }

    public boolean isGenerate2PartVariations() {
        return this.generate2PartVariations;
    }

    public void setGenerate2PartVariations(boolean generate2PartVariations) {
        this.generate2PartVariations = generate2PartVariations;
    }

    public boolean isDropEndParentheticals() {
        return this.dropEndParentheticals;
    }

    public void setDropEndParentheticals(boolean dropEndParentheticals) {
        this.dropEndParentheticals = dropEndParentheticals;
    }
}

