/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging;

import banner.tagging.CRFTagger;
import banner.tagging.FeatureSet;
import banner.tagging.Tagger;
import banner.types.Sentence;
import cc.mallet.fst.CRF;
import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import cc.mallet.types.SequencePairAlignment;
import dragon.nlp.tool.Lemmatiser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class NBestCRFTagger
extends CRFTagger {
    private int n;
    private boolean useMaxConfidence;

    protected NBestCRFTagger(CRF model, FeatureSet featureSet, int order, int n, boolean useMaxConfidence) {
        super(model, featureSet, order);
        this.n = n;
        this.useMaxConfidence = useMaxConfidence;
    }

    public static NBestCRFTagger load(File f, Lemmatiser lemmatiser, dragon.nlp.tool.Tagger posTagger, Tagger preTagger, int n, boolean useMaxConfidence) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(f)));
            CRF model = (CRF)ois.readObject();
            FeatureSet featureSet = (FeatureSet)ois.readObject();
            featureSet.setLemmatiser(lemmatiser);
            featureSet.setPosTagger(posTagger);
            featureSet.setPreTagger(preTagger);
            int order = ois.readInt();
            ois.close();
            return new NBestCRFTagger(model, featureSet, order, n, useMaxConfidence);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void tag(Sentence sentence) {
        Instance instance = this.getInstance(sentence);
        double totalWeight = new SumLatticeDefault((Transducer)this.model, (Sequence)instance.getData()).getTotalWeight();
        MaxLatticeDefault maxLattice = new MaxLatticeDefault((Transducer)this.model, (Sequence)instance.getData(), null, this.n);
        int n2 = maxLattice.bestViterbiNodeSequences(this.n).size();
        List bestOutputAlignments = maxLattice.bestOutputAlignments(n2);
        HashMap<List<String>, Double> tagConfidenceMap = new HashMap<List<String>, Double>();
        for (SequencePairAlignment spa : bestOutputAlignments) {
            List<String> tagList = NBestCRFTagger.getTagList((Sequence<Object>)spa.output());
            double weight = spa.getWeight();
            double confidence = Math.exp(weight - totalWeight);
            if (this.useMaxConfidence) {
                if (tagConfidenceMap.containsKey(tagList) && !((Double)tagConfidenceMap.get(tagList) < confidence)) continue;
                tagConfidenceMap.put(tagList, new Double(confidence));
                continue;
            }
            if (tagConfidenceMap.containsKey(tagList)) {
                double newConfidence = (Double)tagConfidenceMap.get(tagList) + confidence;
                tagConfidenceMap.put(tagList, new Double(newConfidence));
                continue;
            }
            tagConfidenceMap.put(tagList, new Double(confidence));
        }
        double total = 0.0;
        for (List tagList : tagConfidenceMap.keySet()) {
            double confidence = (Double)tagConfidenceMap.get(tagList);
            total += confidence;
        }
        for (List tagList : new HashSet(tagConfidenceMap.keySet())) {
            double normConfidence = (Double)tagConfidenceMap.get(tagList) / total;
            sentence.addMentions(tagList, normConfidence);
        }
    }
}

