/*
 * Decompiled with CFR 0.152.
 */
package banner.postprocessing;

import banner.postprocessing.PostProcessor;
import banner.types.Mention;
import banner.types.Sentence;
import banner.types.Token;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ParenthesisPostProcessor
implements PostProcessor {
    public static boolean isStart(String text) {
        if (text.equals("(")) {
            return true;
        }
        if (text.equals("[")) {
            return true;
        }
        return text.equals("{");
    }

    public static boolean isEnd(String text) {
        if (text.equals(")")) {
            return true;
        }
        if (text.equals("]")) {
            return true;
        }
        return text.equals("}");
    }

    private static boolean isMismatched(Mention mention) {
        List<Token> tokens = mention.getTokens();
        boolean mismatched = false;
        LinkedList<Integer> startMatch = new LinkedList<Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (ParenthesisPostProcessor.isStart(token.getText())) {
                startMatch.add(i);
                continue;
            }
            if (!ParenthesisPostProcessor.isEnd(token.getText())) continue;
            if (startMatch.size() > 0) {
                startMatch.removeLast();
                continue;
            }
            mismatched = true;
        }
        return mismatched || startMatch.size() != 0;
    }

    @Override
    public void postProcess(Sentence sentence) {
        ArrayList<Mention> mentions = new ArrayList<Mention>(sentence.getMentions());
        for (Mention mention : mentions) {
            if (!ParenthesisPostProcessor.isMismatched(mention)) continue;
            sentence.removeMention(mention);
        }
    }
}

