/*
 * Decompiled with CFR 0.152.
 */
package banner.postprocessing;

import banner.tagging.dictionary.DictionaryTagger;
import banner.tokenization.Tokenizer;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Sentence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class OneSensePerDocument {
    private Tokenizer tokenizer;
    private boolean createNew;

    public OneSensePerDocument(Tokenizer tokenizer, boolean createNew) {
        this.tokenizer = tokenizer;
        this.createNew = createNew;
    }

    public void process(List<Sentence> sentences) {
        HashMap<String, Double> mentionTextProbability = new HashMap<String, Double>();
        HashMap<String, HashSet<EntityType>> mentionTextTypes = new HashMap<String, HashSet<EntityType>>();
        for (Sentence sentence : sentences) {
            if (sentence == null) continue;
            for (Mention mention : sentence.getMentions()) {
                HashSet<EntityType> entityTypes;
                String mentionText = mention.getText();
                Double current = (Double)mentionTextProbability.get(mentionText);
                if (current == null || current < mention.getProbability()) {
                    mentionTextProbability.put(mentionText, mention.getProbability());
                }
                if ((entityTypes = (HashSet<EntityType>)mentionTextTypes.get(mentionText)) == null) {
                    entityTypes = new HashSet<EntityType>(1);
                    mentionTextTypes.put(mentionText, entityTypes);
                }
                entityTypes.add(mention.getEntityType());
            }
        }
        DictionaryTagger dictionary = null;
        if (this.createNew) {
            dictionary = new DictionaryTagger();
            dictionary.setTokenizer(this.tokenizer);
            for (String mentionText : mentionTextTypes.keySet()) {
                dictionary.add(mentionText, (Collection<EntityType>)((Collection)mentionTextTypes.get(mentionText)));
            }
        }
        for (Sentence sentence : sentences) {
            if (sentence == null) continue;
            if (this.createNew) {
                dictionary.tag(sentence);
            }
            for (Mention mention : new ArrayList<Mention>(sentence.getMentions())) {
                Double probability = (Double)mentionTextProbability.get(mention.getText());
                if (probability == null) {
                    sentence.removeMention(mention);
                    continue;
                }
                mention.setProbability(probability);
            }
        }
    }
}

