/*
 * Decompiled with CFR 0.152.
 */
package banner.normalization;

import banner.normalization.MentionIdentifier;
import banner.types.Entity;
import banner.types.EntityIdentification;
import banner.types.EntityName;
import banner.types.Mention;
import banner.types.Sentence;
import banner.util.IndexedMetricSetSimilarity;
import banner.util.RankedList;
import banner.util.SetSimilarityMetric;

public class IndexedMentionIdentifier
implements MentionIdentifier {
    private IndexedMetricSetSimilarity<String, EntityName> identifier;

    public IndexedMentionIdentifier(SetSimilarityMetric metric, int resultsSize) {
        this.identifier = new IndexedMetricSetSimilarity<String, EntityName>(metric, resultsSize){

            @Override
            protected String transform(String element) {
                return element.toLowerCase();
            }
        };
    }

    @Override
    public void addEntity(Entity entity) {
        for (EntityName name : entity.getNames()) {
            this.identifier.addValue(name.getElements(), name);
        }
    }

    @Override
    public void identifyMentions(Sentence sentence) {
        for (Mention mention : sentence.getMentions()) {
            EntityIdentification identification = new EntityIdentification(mention);
            EntityName mentionName = EntityName.createFromTokens(mention.getText(), mention.getTokens());
            RankedList<EntityName> matches = this.identifier.indexMatch(mentionName.getElements());
            for (int i = 0; i < matches.size(); ++i) {
                identification.set(matches.getObject(i), matches.getValue(i));
            }
            sentence.setIdentification(mention, identification);
        }
    }
}

