/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class UnmodifiableArraySet<E>
implements Set<E> {
    private E[] values;

    public UnmodifiableArraySet(Set<? extends E> c) {
        this.values = new Object[c.size()];
        Iterator<E> i = c.iterator();
        int current = 0;
        while (i.hasNext()) {
            this.values[current++] = i.next();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableArraySetIterator();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!o.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException();
    }

    private class UnmodifiableArraySetIterator
    implements Iterator<E> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < UnmodifiableArraySet.this.values.length;
        }

        @Override
        public E next() {
            return UnmodifiableArraySet.this.values[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

