/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Trie<K, V> {
    private V value;
    private Map<K, Trie<K, V>> children;

    public Trie() {
        this(null);
    }

    public Trie(V value) {
        this.value = value;
        this.children = null;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public V add(List<K> keys, V value) {
        Trie<K, V> current = this;
        Iterator<K> keyIterator = keys.iterator();
        while (current != null && keyIterator.hasNext()) {
            Trie<K, V> next;
            K nextKey = keyIterator.next();
            if (current.children == null) {
                current.children = new HashMap<K, Trie<K, V>>(1);
            }
            if ((next = current.children.get(nextKey)) == null) {
                next = new Trie<K, V>();
                current.children.put(nextKey, next);
            }
            current = next;
        }
        V old = current.value;
        current.value = value;
        return old;
    }

    public Trie<K, V> getChild(K key) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(key);
    }

    public V getValue(List<K> keys) {
        Trie<K, V> current = this;
        Iterator<K> keyIterator = keys.iterator();
        while (current != null && keyIterator.hasNext()) {
            K nextKey = keyIterator.next();
            if (current.children == null) {
                current = null;
                continue;
            }
            current = current.children.get(nextKey);
        }
        if (current == null) {
            return null;
        }
        return current.getValue();
    }

    public int size() {
        int size = 0;
        if (this.value != null) {
            ++size;
        }
        if (this.children != null) {
            for (Trie<K, V> child : this.children.values()) {
                size += child.size();
            }
        }
        return size;
    }
}

